/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.http.Http;
import swim.http.header.RawHeader;

final class RawHeaderParser
extends Parser<RawHeader> {
    final String lowerCaseName;
    final String name;
    final Output<String> valueOutput;
    final int step;

    RawHeaderParser(String lowerCaseName, String name, Output<String> valueOutput, int step) {
        this.lowerCaseName = lowerCaseName;
        this.name = name;
        this.valueOutput = valueOutput;
        this.step = step;
    }

    RawHeaderParser(String lowerCaseName, String name) {
        this(lowerCaseName, name, null, 1);
    }

    public Parser<RawHeader> feed(Input input) {
        return RawHeaderParser.parse(input, this.lowerCaseName, this.name, this.valueOutput, this.step);
    }

    static Parser<RawHeader> parse(Input input, String lowerCaseName, String name, Output<String> valueOutput, int step) {
        block10: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (valueOutput == null) {
                        valueOutput = Utf8.decodedString();
                    }
                    while (input.isCont() && Http.isFieldChar(c = input.head())) {
                        input = input.step();
                        valueOutput.write(c);
                    }
                    if (input.isCont() && Http.isSpace(c)) {
                        input = input.step();
                        step = 2;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)RawHeader.create(lowerCaseName, name, (String)valueOutput.bind()));
                    }
                }
                if (step != 2) break block10;
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (!input.isCont() || !Http.isFieldChar(c)) break;
                input = input.step();
                valueOutput = valueOutput.write(32);
                valueOutput = valueOutput.write(c);
                step = 1;
            }
            if (!input.isEmpty()) {
                return Parser.done((Object)RawHeader.create(lowerCaseName, name, (String)valueOutput.bind()));
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new RawHeaderParser(lowerCaseName, name, (Output<String>)valueOutput, step);
    }

    static Parser<RawHeader> parse(Input input, String lowerCaseName, String name) {
        return RawHeaderParser.parse(input, lowerCaseName, name, null, 1);
    }
}

