/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.SecWebSocketProtocolHeaderParser;
import swim.util.Murmur3;

public final class SecWebSocketProtocolHeader
extends HttpHeader {
    final FingerTrieSeq<String> protocols;
    private static int hashSeed;

    SecWebSocketProtocolHeader(FingerTrieSeq<String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public boolean isBlank() {
        return this.protocols.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-protocol";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Protocol";
    }

    public FingerTrieSeq<String> protocols() {
        return this.protocols;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(output, this.protocols.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketProtocolHeader) {
            SecWebSocketProtocolHeader that = (SecWebSocketProtocolHeader)other;
            return this.protocols.equals(that.protocols);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketProtocolHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.protocols.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("SecWebSocketProtocolHeader").write(46).write("create").write(40);
        int n = this.protocols.size();
        if (n > 0) {
            output = output.debug(this.protocols.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.protocols.head());
            }
        }
        output = output.write(41);
        return output;
    }

    public static SecWebSocketProtocolHeader empty() {
        return new SecWebSocketProtocolHeader((FingerTrieSeq<String>)FingerTrieSeq.empty());
    }

    public static SecWebSocketProtocolHeader create(FingerTrieSeq<String> protocols) {
        return new SecWebSocketProtocolHeader(protocols);
    }

    public static SecWebSocketProtocolHeader create(String ... protocols) {
        return new SecWebSocketProtocolHeader((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])protocols));
    }

    public static Parser<SecWebSocketProtocolHeader> parseHeaderValue(Input input, HttpParser http) {
        return SecWebSocketProtocolHeaderParser.parse(input, http);
    }
}

