/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import java.util.Iterator;
import swim.codec.Binary;
import swim.codec.Encoder;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.hpack.HpackBlockEncoder;
import swim.hpack.HpackHeader;
import swim.hpack.HpackHeaderEncoder;
import swim.hpack.HpackIndexing;
import swim.hpack.HpackIntegerEncoder;
import swim.hpack.HpackStringEncoder;
import swim.hpack.HpackTableMap;
import swim.hpack.HpackTableStatic;
import swim.hpack.Huffman;
import swim.hpack.HuffmanEncodedOutput;

public class HpackEncoder {
    final HpackTableStatic staticTable;
    final HpackTableMap dynamicTable;
    final int[] codes;
    final byte[] lengths;

    HpackEncoder(HpackTableStatic staticTable, HpackTableMap dynamicTable, int[] codes, byte[] lengths) {
        this.staticTable = staticTable;
        this.dynamicTable = dynamicTable;
        this.codes = codes;
        this.lengths = lengths;
    }

    public HpackEncoder(int capacity) {
        this(HpackTableStatic.standard(), HpackTableMap.withCapacity(capacity), Huffman.CODES, Huffman.LENGTHS);
    }

    public HpackEncoder() {
        this(4096);
    }

    public int size() {
        return this.dynamicTable.size();
    }

    public int capacity() {
        return this.dynamicTable.capacity();
    }

    public void setCapacity(int capacity) {
        if (this.dynamicTable.capacity != capacity) {
            this.dynamicTable.setCapacity(capacity);
        }
    }

    public int length() {
        return this.staticTable.length() + this.dynamicTable.length();
    }

    public int getIndex(byte[] name) {
        int index = this.staticTable.getIndex(name);
        if (index < 0 && (index = this.dynamicTable.getIndex(name)) >= 0) {
            index += this.staticTable.length();
        }
        return index;
    }

    public Encoder<?, ?> encodeBlock(OutputBuffer<?> output, Iterator<HpackHeader> headers) {
        return HpackBlockEncoder.encode(output, this, headers);
    }

    public Encoder<?, ?> blockEncoder(Iterator<HpackHeader> headers) {
        return new HpackBlockEncoder(this, headers);
    }

    public Encoder<?, ?> encodeHeader(OutputBuffer<?> output, HpackHeader header, HpackIndexing indexing) {
        if (header.isSensitive()) {
            int index = this.getIndex(header.name);
            if (index > 0) {
                return this.encodeHeader(output, index, null, this.stringEncoder(header.value), HpackIndexing.NEVER);
            }
            return this.encodeHeader(output, 0, this.stringEncoder(header.name), this.stringEncoder(header.value), HpackIndexing.NEVER);
        }
        if (this.dynamicTable.capacity == 0) {
            int index = this.staticTable.getIndex(header.name, header.value);
            if (index == -1) {
                index = this.staticTable.getIndex(header.name);
                if (index > 0) {
                    return this.encodeHeader(output, index, null, this.stringEncoder(header.value), HpackIndexing.NONE);
                }
                return this.encodeHeader(output, 0, this.stringEncoder(header.name), this.stringEncoder(header.value), HpackIndexing.NONE);
            }
            return this.encodeHeader(output, index);
        }
        int headerSize = header.hpackSize();
        if (headerSize > this.dynamicTable.capacity) {
            int index = this.getIndex(header.name);
            if (index > 0) {
                return this.encodeHeader(output, index, null, this.stringEncoder(header.value), HpackIndexing.NONE);
            }
            return this.encodeHeader(output, 0, this.stringEncoder(header.name), this.stringEncoder(header.value), HpackIndexing.NONE);
        }
        HpackTableMap.Entry entry = this.dynamicTable.getEntry(header);
        if (entry != null) {
            int index = this.dynamicTable.getIndex(entry) + this.staticTable.length();
            return this.encodeHeader(output, index);
        }
        int index = this.staticTable.getIndex(header.name, header.value);
        if (index > 0) {
            return this.encodeHeader(output, index);
        }
        index = this.getIndex(header.name);
        if (indexing == HpackIndexing.INCREMENTAL) {
            this.dynamicTable.ensureCapacity(headerSize);
            this.dynamicTable.add(header);
        }
        if (index > 0) {
            return this.encodeHeader(output, index, null, this.stringEncoder(header.value), indexing);
        }
        return this.encodeHeader(output, 0, this.stringEncoder(header.name), this.stringEncoder(header.value), indexing);
    }

    public Encoder<?, ?> headerEncoder(HpackHeader header, HpackIndexing indexing) {
        if (header.isSensitive()) {
            int index = this.getIndex(header.name);
            if (index > 0) {
                return this.headerEncoder(index, null, this.stringEncoder(header.value), HpackIndexing.NEVER);
            }
            return this.headerEncoder(0, this.stringEncoder(header.name), this.stringEncoder(header.value), HpackIndexing.NEVER);
        }
        if (this.dynamicTable.capacity == 0) {
            int index = this.staticTable.getIndex(header.name, header.value);
            if (index == -1) {
                index = this.staticTable.getIndex(header.name);
                if (index > 0) {
                    return this.headerEncoder(index, null, this.stringEncoder(header.value), HpackIndexing.NONE);
                }
                return this.headerEncoder(0, this.stringEncoder(header.name), this.stringEncoder(header.value), HpackIndexing.NONE);
            }
            return this.headerEncoder(index);
        }
        int headerSize = header.hpackSize();
        if (headerSize > this.dynamicTable.capacity) {
            int index = this.getIndex(header.name);
            if (index > 0) {
                return this.headerEncoder(index, null, this.stringEncoder(header.value), HpackIndexing.NONE);
            }
            return this.headerEncoder(0, this.stringEncoder(header.name), this.stringEncoder(header.value), HpackIndexing.NONE);
        }
        HpackTableMap.Entry entry = this.dynamicTable.getEntry(header);
        if (entry != null) {
            int index = this.dynamicTable.getIndex(entry) + this.staticTable.length();
            return this.headerEncoder(index);
        }
        int index = this.staticTable.getIndex(header.name, header.value);
        if (index > 0) {
            return this.headerEncoder(index);
        }
        index = this.getIndex(header.name);
        if (indexing == HpackIndexing.INCREMENTAL) {
            this.dynamicTable.ensureCapacity(headerSize);
            this.dynamicTable.add(header);
        }
        if (index > 0) {
            return this.headerEncoder(index, null, this.stringEncoder(header.value), indexing);
        }
        return this.headerEncoder(0, this.stringEncoder(header.name), this.stringEncoder(header.value), indexing);
    }

    public Encoder<?, ?> encodeHeader(OutputBuffer<?> output, HpackHeader header) {
        return this.encodeHeader(output, header, HpackIndexing.INCREMENTAL);
    }

    public Encoder<?, ?> headerEncoder(HpackHeader header) {
        return this.headerEncoder(header, HpackIndexing.INCREMENTAL);
    }

    public Encoder<?, ?> encodeHeader(OutputBuffer<?> output, int index, Encoder<?, ?> nameEncoder, Encoder<?, ?> valueEncoder, HpackIndexing indexing) {
        return HpackHeaderEncoder.encode(output, index, nameEncoder, valueEncoder, indexing);
    }

    public Encoder<?, ?> headerEncoder(int index, Encoder<?, ?> nameEncoder, Encoder<?, ?> valueEncoder, HpackIndexing indexing) {
        return new HpackHeaderEncoder(index, nameEncoder, valueEncoder, indexing);
    }

    public Encoder<?, ?> encodeHeader(OutputBuffer<?> output, int index) {
        return HpackHeaderEncoder.encode(output, index, null, null, null);
    }

    public Encoder<?, ?> headerEncoder(int index) {
        return new HpackHeaderEncoder(index, null, null, null);
    }

    public Encoder<?, ?> encodeInteger(OutputBuffer<?> output, int prefixMask, int prefixBits, int value) {
        return HpackIntegerEncoder.encode(output, prefixMask, prefixBits, value);
    }

    public Encoder<?, ?> integerEncoder(int prefixMask, int prefixBits, int value) {
        return new HpackIntegerEncoder(prefixMask, prefixBits, value);
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, Input input, int length, boolean huffmanEncode) {
        if (huffmanEncode) {
            Input sizeInput = input.clone();
            long encodedSize = 0L;
            while (sizeInput.isCont()) {
                int b = sizeInput.head();
                sizeInput = sizeInput.step();
                encodedSize += (long)this.lengths[b];
            }
            encodedSize = encodedSize + 7L >>> 3;
            return HpackStringEncoder.encode(output, input, (int)encodedSize, this.huffmanEncodedOutput());
        }
        return HpackStringEncoder.encode(output, input, length, null);
    }

    public Encoder<?, ?> stringEncoder(Input input, int length, boolean huffmanEncode) {
        if (huffmanEncode) {
            Input sizeInput = input.clone();
            long encodedSize = 0L;
            while (sizeInput.isCont()) {
                int b = sizeInput.head();
                sizeInput = sizeInput.step();
                encodedSize += (long)this.lengths[b];
            }
            encodedSize = encodedSize + 7L >>> 3;
            return new HpackStringEncoder(input, (int)encodedSize, this.huffmanEncodedOutput());
        }
        return new HpackStringEncoder(input, length, null);
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, Input input, boolean huffmanEncode) {
        Input sizeInput = input.clone();
        long encodedSize = 0L;
        int decodedSize = 0;
        while (sizeInput.isCont()) {
            int b = sizeInput.head();
            sizeInput = sizeInput.step();
            encodedSize += (long)this.lengths[b];
            ++decodedSize;
        }
        encodedSize = encodedSize + 7L >>> 3;
        if (huffmanEncode) {
            return HpackStringEncoder.encode(output, input, (int)encodedSize, this.huffmanEncodedOutput());
        }
        return HpackStringEncoder.encode(output, input, decodedSize, null);
    }

    public Encoder<?, ?> stringEncoder(Input input, boolean huffmanEncode) {
        Input sizeInput = input.clone();
        long encodedSize = 0L;
        int decodedSize = 0;
        while (sizeInput.isCont()) {
            int b = sizeInput.head();
            sizeInput = sizeInput.step();
            encodedSize += (long)this.lengths[b];
            ++decodedSize;
        }
        encodedSize = encodedSize + 7L >>> 3;
        if (huffmanEncode) {
            return new HpackStringEncoder(input, (int)encodedSize, this.huffmanEncodedOutput());
        }
        return new HpackStringEncoder(input, decodedSize, null);
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, Input input) {
        Input sizeInput = input.clone();
        long encodedSize = 0L;
        int decodedSize = 0;
        while (sizeInput.isCont()) {
            int b = sizeInput.head();
            sizeInput = sizeInput.step();
            encodedSize += (long)this.lengths[b];
            ++decodedSize;
        }
        if ((int)(encodedSize = encodedSize + 7L >>> 3) < decodedSize) {
            return HpackStringEncoder.encode(output, input, (int)encodedSize, this.huffmanEncodedOutput());
        }
        return HpackStringEncoder.encode(output, input, decodedSize, null);
    }

    public Encoder<?, ?> stringEncoder(Input input) {
        Input sizeInput = input.clone();
        long encodedSize = 0L;
        int decodedSize = 0;
        while (sizeInput.isCont()) {
            int b = sizeInput.head();
            sizeInput = sizeInput.step();
            encodedSize += (long)this.lengths[b];
            ++decodedSize;
        }
        if ((int)(encodedSize = encodedSize + 7L >>> 3) < decodedSize) {
            return new HpackStringEncoder(input, (int)encodedSize, this.huffmanEncodedOutput());
        }
        return new HpackStringEncoder(input, decodedSize, null);
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, String string, boolean huffmanEncode) {
        return this.encodeString(output, Utf8.decodedInput((String)string), huffmanEncode);
    }

    public Encoder<?, ?> stringEncoder(String string, boolean huffmanEncode) {
        return this.stringEncoder(Utf8.decodedInput((String)string), huffmanEncode);
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, String string) {
        return this.encodeString(output, Utf8.decodedInput((String)string));
    }

    public Encoder<?, ?> stringEncoder(String string) {
        return this.stringEncoder(Utf8.decodedInput((String)string));
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, byte[] string, boolean huffmanEncode) {
        if (huffmanEncode) {
            return HpackStringEncoder.encode(output, (Input)Binary.inputBuffer((byte[])string), this.huffmanEncodedSize(string), this.huffmanEncodedOutput());
        }
        return HpackStringEncoder.encode(output, (Input)Binary.inputBuffer((byte[])string), string.length, null);
    }

    public Encoder<?, ?> stringEncoder(byte[] string, boolean huffmanEncode) {
        if (huffmanEncode) {
            return new HpackStringEncoder((Input)Binary.inputBuffer((byte[])string), this.huffmanEncodedSize(string), this.huffmanEncodedOutput());
        }
        return new HpackStringEncoder((Input)Binary.inputBuffer((byte[])string), string.length, null);
    }

    int huffmanEncodedSize(byte[] string) {
        long encodedSize = 0L;
        int n = string.length;
        for (int i = 0; i < n; ++i) {
            int b = string[i] & 0xFF;
            encodedSize += (long)this.lengths[b];
        }
        return (int)(encodedSize + 7L >>> 3);
    }

    public Encoder<?, ?> encodeString(OutputBuffer<?> output, byte[] string) {
        int huffmanEncodedSize = this.huffmanEncodedSize(string);
        if (huffmanEncodedSize < string.length) {
            return HpackStringEncoder.encode(output, (Input)Binary.inputBuffer((byte[])string), huffmanEncodedSize, this.huffmanEncodedOutput());
        }
        return HpackStringEncoder.encode(output, (Input)Binary.inputBuffer((byte[])string), string.length, null);
    }

    public Encoder<?, ?> stringEncoder(byte[] string) {
        int huffmanEncodedSize = this.huffmanEncodedSize(string);
        if (huffmanEncodedSize < string.length) {
            return new HpackStringEncoder((Input)Binary.inputBuffer((byte[])string), huffmanEncodedSize, this.huffmanEncodedOutput());
        }
        return new HpackStringEncoder((Input)Binary.inputBuffer((byte[])string), string.length, null);
    }

    public <T> Output<T> huffmanEncodedOutput(Output<T> output) {
        return new HuffmanEncodedOutput<T>(output, this.codes, this.lengths);
    }

    public Output<?> huffmanEncodedOutput() {
        return new HuffmanEncodedOutput(Output.full(), this.codes, this.lengths);
    }

    public HpackEncoder clone() {
        return new HpackEncoder(this.staticTable, this.dynamicTable.clone(), this.codes, this.lengths);
    }
}

