/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.hpack.HpackDecoder;
import swim.hpack.HpackHeader;
import swim.hpack.HuffmanDecodedInput;

final class HpackHeaderDecoder
extends Decoder<HpackHeader> {
    final HpackDecoder hpack;
    final Output<byte[]> nameOutput;
    final Output<byte[]> valueOutput;
    final Input huffmanInput;
    final boolean sensitive;
    final int index;
    final int value;
    final int shift;
    final int step;

    HpackHeaderDecoder(HpackDecoder hpack, Output<byte[]> nameOutput, Output<byte[]> valueOutput, Input huffmanInput, boolean sensitive, int index, int value, int shift, int step) {
        this.hpack = hpack;
        this.nameOutput = nameOutput;
        this.valueOutput = valueOutput;
        this.huffmanInput = huffmanInput;
        this.sensitive = sensitive;
        this.index = index;
        this.value = value;
        this.shift = shift;
        this.step = step;
    }

    HpackHeaderDecoder(HpackDecoder hpack) {
        this(hpack, null, null, null, false, 0, 0, 0, 1);
    }

    public Decoder<HpackHeader> feed(InputBuffer input) {
        return HpackHeaderDecoder.decode(input, this.hpack, this.nameOutput, this.valueOutput, this.huffmanInput, this.sensitive, this.index, this.value, this.shift, this.step);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Decoder<HpackHeader> decode(InputBuffer input, HpackDecoder hpack, Output<byte[]> nameOutput, Output<byte[]> valueOutput, Input huffmanInput, boolean sensitive, int index, int value, int shift, int step) {
        boolean inputPart;
        int inputRemaining;
        int inputLimit;
        HpackHeader header;
        int b;
        block80: {
            block83: {
                block84: {
                    if (step != 1) break block80;
                    if (!input.isCont()) break block83;
                    b = input.head();
                    input = input.step();
                    if ((b & 0x80) != 0) {
                        index = b & 0x7F;
                        if (index == 127) {
                            step = 2;
                            break block80;
                        } else {
                            if (index == 0) {
                                return Decoder.error((Throwable)new DecoderException("invalid index: " + index));
                            }
                            HpackHeader header2 = hpack.get(index);
                            if (header2 != null) {
                                return Decoder.done((Object)header2);
                            }
                            return Decoder.error((Throwable)new DecoderException("invalid index: " + index));
                        }
                    }
                    if ((b & 0x40) == 0) break block84;
                    index = b & 0x3F;
                    if (index == 63) {
                        step = 3;
                        break block80;
                    } else if (index == 0) {
                        step = 4;
                        break block80;
                    } else {
                        header = hpack.get(index);
                        if (header == null) {
                            return Decoder.error((Throwable)new DecoderException("invalid index: " + index));
                        }
                        nameOutput = Binary.byteArrayOutput((byte[])header.name);
                        step = 8;
                    }
                    break block80;
                }
                if ((b & 0x20) != 0) {
                    return Decoder.error((Throwable)new DecoderException("unexpected dynamic table size update"));
                }
                if ((b & 0x10) != 0) {
                    sensitive = true;
                }
                if ((index = b & 0xF) == 15) {
                    step = 3;
                    break block80;
                } else if (index == 0) {
                    step = 4;
                    break block80;
                } else {
                    header = hpack.get(index);
                    if (header == null) {
                        return Decoder.error((Throwable)new DecoderException("invalid index: " + index));
                    }
                    nameOutput = Binary.byteArrayOutput((byte[])header.name);
                    step = 8;
                }
                break block80;
            }
            if (input.isDone()) {
                return Decoder.error((Throwable)new DecoderException("expected literal header"));
            }
        }
        if (step == 2) {
            while (input.isCont()) {
                b = input.head();
                input = input.step();
                if (shift == 28 && (b & 0xF8) != 0) {
                    return Decoder.error((Throwable)new DecoderException("index overflow"));
                }
                value |= (b & 0x7F) << shift;
                if ((b & 0x80) != 0) {
                    if ((shift += 7) < 32) continue;
                    return Decoder.error((Throwable)new DecoderException("index overflow"));
                }
                if ((index += value) < 0) {
                    return Decoder.error((Throwable)new DecoderException("index overflow"));
                }
                header = hpack.get(index);
                if (header != null) {
                    return Decoder.done((Object)header);
                }
                return Decoder.error((Throwable)new DecoderException("invalid index: " + index));
            }
        }
        if (step == 3) {
            while (input.isCont()) {
                b = input.head();
                input = input.step();
                if (shift == 28 && (b & 0xF8) != 0) {
                    return Decoder.error((Throwable)new DecoderException("index overflow"));
                }
                value |= (b & 0x7F) << shift;
                if ((b & 0x80) != 0) {
                    if ((shift += 7) < 32) continue;
                    return Decoder.error((Throwable)new DecoderException("index overflow"));
                }
                if ((index += value) < 0) {
                    return Decoder.error((Throwable)new DecoderException("index overflow"));
                }
                header = hpack.get(index);
                if (header == null) {
                    return Decoder.error((Throwable)new DecoderException("invalid index: " + index));
                }
                nameOutput = Binary.byteArrayOutput((byte[])header.name);
                value = 0;
                shift = 0;
                step = 8;
            }
        }
        if (step == 4) {
            if (input.isCont()) {
                b = input.head();
                input = input.step();
                huffmanInput = (b & 0x80) != 0 ? new HuffmanDecodedInput(Input.empty()) : null;
                index = b & 0x7F;
                if (index == 127) {
                    step = 5;
                } else {
                    if (index == 0) {
                        return Decoder.error((Throwable)new DecoderException("empty header name"));
                    }
                    step = 6;
                }
            } else if (input.isDone()) {
                return Decoder.error((Throwable)new DecoderException("expected literal header name length prefix"));
            }
        }
        if (step == 5) {
            while (input.isCont()) {
                b = input.head();
                input = input.step();
                if (shift == 28 && (b & 0xF8) != 0) {
                    return Decoder.error((Throwable)new DecoderException("length overflow"));
                }
                value |= (b & 0x7F) << shift;
                if ((b & 0x80) != 0) {
                    if ((shift += 7) < 32) continue;
                    return Decoder.error((Throwable)new DecoderException("length overflow"));
                }
                if ((index += value) < 0) {
                    return Decoder.error((Throwable)new DecoderException("length overflow"));
                }
                value = 0;
                shift = 0;
                step = 6;
            }
        }
        if (step == 6) {
            int inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (index < inputRemaining) {
                input = input.limit(inputStart + index);
            }
            inputPart = input.isPart();
            input = input.isPart(index > inputRemaining);
            if (nameOutput == null) {
                nameOutput = Binary.byteArrayOutput((int)index);
            }
            if (huffmanInput != null) {
                huffmanInput = huffmanInput.fork((Object)input);
                while (huffmanInput.isCont()) {
                    nameOutput = nameOutput.write(huffmanInput.head());
                    huffmanInput = huffmanInput.step();
                }
                huffmanInput = huffmanInput.fork((Object)Input.empty());
            } else {
                while (input.isCont()) {
                    nameOutput = nameOutput.write(input.head());
                    input = input.step();
                }
            }
            input = input.limit(inputLimit).isPart(inputPart);
            index -= input.index() - inputStart;
            if (nameOutput.isError()) {
                return Decoder.error((Throwable)nameOutput.trap());
            }
            if (index == 0) {
                huffmanInput = null;
                step = 8;
            }
        }
        if (step == 7) {
            while (input.isCont() && index != 0) {
                input = input.step();
                --index;
            }
            if (index == 0) {
                step = 8;
            }
        }
        if (step == 8) {
            if (input.isCont()) {
                b = input.head();
                input = input.step();
                huffmanInput = (b & 0x80) != 0 ? new HuffmanDecodedInput(Input.empty()) : null;
                index = b & 0x7F;
                if (index == 127) {
                    step = 9;
                } else {
                    if (index == 0) {
                        return Decoder.done((Object)HpackHeader.create((byte[])nameOutput.bind(), HpackHeader.EMPTY_VALUE, sensitive));
                    }
                    step = 10;
                }
            } else if (input.isDone()) {
                return Decoder.error((Throwable)new DecoderException("expected literal header value length prefix"));
            }
        }
        if (step == 9) {
            while (input.isCont()) {
                b = input.head();
                input = input.step();
                if (shift == 28 && (b & 0xF8) != 0) {
                    return Decoder.error((Throwable)new DecoderException("length overflow"));
                }
                value |= (b & 0x7F) << shift;
                if ((b & 0x80) != 0) {
                    if ((shift += 7) < 32) continue;
                    return Decoder.error((Throwable)new DecoderException("length overflow"));
                }
                if ((index += value) < 0) {
                    return Decoder.error((Throwable)new DecoderException("length overflow"));
                }
                value = 0;
                shift = 0;
                step = 10;
            }
        }
        if (step == 10) {
            int inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (index < inputRemaining) {
                input = input.limit(inputStart + index);
            }
            inputPart = input.isPart();
            input = input.isPart(index > inputRemaining);
            if (valueOutput == null) {
                valueOutput = Binary.byteArrayOutput((int)index);
            }
            if (huffmanInput != null) {
                huffmanInput = huffmanInput.fork((Object)input);
                while (huffmanInput.isCont()) {
                    valueOutput = valueOutput.write(huffmanInput.head());
                    huffmanInput = huffmanInput.step();
                }
                huffmanInput = huffmanInput.fork((Object)Input.empty());
            } else {
                while (input.isCont()) {
                    valueOutput = valueOutput.write(input.head());
                    input = input.step();
                }
            }
            input = input.limit(inputLimit).isPart(inputPart);
            index -= input.index() - inputStart;
            if (valueOutput.isError()) {
                return Decoder.error((Throwable)valueOutput.trap());
            }
            if (index == 0) {
                return Decoder.done((Object)HpackHeader.create((byte[])nameOutput.bind(), (byte[])valueOutput.bind(), sensitive));
            }
        }
        if (step == 11) {
            while (input.isCont() && index != 0) {
                input = input.step();
                --index;
            }
            if (index == 0) {
                return Decoder.done();
            }
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new HpackHeaderDecoder(hpack, (Output<byte[]>)nameOutput, (Output<byte[]>)valueOutput, huffmanInput, sensitive, index, value, shift, step);
    }

    static Decoder<HpackHeader> decode(InputBuffer input, HpackDecoder hpack) {
        return HpackHeaderDecoder.decode(input, hpack, null, null, null, false, 0, 0, 0, 1);
    }
}

