/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import java.util.Arrays;
import swim.hpack.HpackHeader;

final class HpackTableMap {
    final Entry[] entries;
    final Entry head;
    int size;
    int capacity;

    HpackTableMap(Entry[] entries, Entry head, int size, int capacity) {
        this.entries = entries;
        this.head = head;
        this.size = size;
        this.capacity = capacity;
    }

    int length() {
        if (this.size != 0) {
            Entry head = this.head;
            return head.after.index - head.before.index + 1;
        }
        return 0;
    }

    int size() {
        return this.size;
    }

    int capacity() {
        return this.capacity;
    }

    void setCapacity(int capacity) {
        this.capacity = capacity;
        this.ensureCapacity(0);
    }

    void ensureCapacity(int headerSize) {
        while (this.size + headerSize > this.capacity && this.length() != 0) {
            this.removeEntry();
        }
    }

    HpackHeader get(int index) {
        return this.getEntry((int)index).header;
    }

    Entry getEntry(int index) {
        --index;
        Entry entry = this.head;
        while (index >= 0) {
            entry = entry.before;
            --index;
        }
        return entry;
    }

    Entry getEntry(HpackHeader header) {
        if (this.length() != 0 && header != null) {
            int hash = this.hash(header.name);
            int i = hash % this.entries.length;
            Entry entry = this.entries[i];
            while (entry != null) {
                if (entry.hash == hash && entry.header.equals(header)) {
                    return entry;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    int getIndex(byte[] name) {
        if (this.length() != 0 && name != null) {
            int hash = this.hash(name);
            int i = hash % this.entries.length;
            Entry entry = this.entries[i];
            while (entry != null) {
                if (entry.hash == hash && entry.header.equalsName(name)) {
                    return this.getIndex(entry);
                }
                entry = entry.next;
            }
        }
        return -1;
    }

    int getIndex(Entry entry) {
        return entry.index - this.head.before.index + 1;
    }

    void add(HpackHeader header) {
        int headerSize = header.hpackSize();
        if (headerSize > this.capacity) {
            this.clear();
        } else {
            Entry newEntry;
            while (this.size + headerSize > this.capacity) {
                this.removeEntry();
            }
            int hash = this.hash(header.name);
            int i = hash % this.entries.length;
            int index = this.head.before.index - 1;
            Entry oldEntry = this.entries[i];
            this.entries[i] = newEntry = new Entry(header, hash, index, oldEntry, null, null);
            newEntry.addBefore(this.head);
            this.size += headerSize;
        }
    }

    Entry removeEntry() {
        if (this.size != 0) {
            Entry prev;
            Entry eldest = this.head.after;
            int i = eldest.hash % this.entries.length;
            Entry entry = prev = this.entries[i];
            while (entry != null) {
                Entry next = entry.next;
                if (entry == eldest) {
                    if (prev == eldest) {
                        this.entries[i] = next;
                    } else {
                        prev.next = next;
                    }
                    eldest.remove();
                    this.size -= eldest.header.hpackSize();
                    return eldest;
                }
                prev = entry;
                entry = next;
            }
        }
        return null;
    }

    HpackHeader remove() {
        Entry entry = this.removeEntry();
        return entry != null ? entry.header : null;
    }

    void clear() {
        Entry head;
        Arrays.fill(this.entries, null);
        head.before = head = this.head;
        head.after = head;
        this.size = 0;
    }

    int hash(byte[] name) {
        int h = 0;
        for (int i = 0; i < name.length; ++i) {
            h = 31 * h + name[i];
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    public HpackTableMap clone() {
        HpackTableMap dynamicTable = HpackTableMap.withCapacity(this.capacity);
        Entry entry = this.head.after;
        while (entry != null && entry.header != null) {
            dynamicTable.add(entry.header);
            entry = entry.after;
        }
        return dynamicTable;
    }

    static HpackTableMap withCapacity(int capacity) {
        Entry head;
        Entry[] entries = new Entry[17];
        head.before = head = new Entry(null, -1, Integer.MAX_VALUE);
        head.after = head;
        return new HpackTableMap(entries, head, 0, capacity);
    }

    static final class Entry {
        HpackHeader header;
        int hash;
        int index;
        Entry next;
        Entry before;
        Entry after;

        Entry(HpackHeader header, int hash, int index, Entry next, Entry before, Entry after) {
            this.header = header;
            this.hash = hash;
            this.index = index;
            this.next = next;
            this.before = before;
            this.after = after;
        }

        Entry(HpackHeader header, int hash, int index) {
            this(header, hash, index, null, null, null);
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.before = null;
            this.after = null;
            this.next = null;
        }

        void addBefore(Entry that) {
            this.after = that;
            this.before = that.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

