/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.hpack.HpackDecoder;
import swim.hpack.HpackException;
import swim.hpack.HpackHeader;
import swim.util.Builder;

final class HpackBlockDecoder
extends Decoder<FingerTrieSeq<HpackHeader>> {
    final HpackDecoder hpack;
    final Builder<HpackHeader, FingerTrieSeq<HpackHeader>> headers;
    final Decoder<HpackHeader> headerDecoder;
    final boolean indexed;
    final int value;
    final int shift;
    final int step;

    HpackBlockDecoder(HpackDecoder hpack, Builder<HpackHeader, FingerTrieSeq<HpackHeader>> headers, Decoder<HpackHeader> headerDecoder, boolean indexed, int value, int shift, int step) {
        this.hpack = hpack;
        this.headers = headers;
        this.headerDecoder = headerDecoder;
        this.indexed = indexed;
        this.value = value;
        this.shift = shift;
        this.step = step;
    }

    HpackBlockDecoder(HpackDecoder hpack) {
        this(hpack, null, null, false, 0, 0, 1);
    }

    public Decoder<FingerTrieSeq<HpackHeader>> feed(InputBuffer input) {
        return HpackBlockDecoder.decode(input, this.hpack, this.headers, this.headerDecoder, this.indexed, this.value, this.shift, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static Decoder<FingerTrieSeq<HpackHeader>> decode(InputBuffer input, HpackDecoder hpack, Builder<HpackHeader, FingerTrieSeq<HpackHeader>> headers, Decoder<HpackHeader> headerDecoder2222, boolean indexed, int value, int shift, int step) {
        void headerDecoder2222;
        block0: while (true) {
            int maxDynamicTableSize;
            int b;
            block23: {
                block24: {
                    block25: {
                        if (step != true) break block23;
                        if (!input.isCont()) break block24;
                        b = input.head();
                        if (hpack.maxDynamicTableSizeChanged && (b & 0xE0) != 32) {
                            return Decoder.error((Throwable)new HpackException("max dynamic table size change required"));
                        }
                        if ((b & 0x80) == 0) break block25;
                        step = 2;
                        break block23;
                    }
                    if ((b & 0x40) != 0) {
                        indexed = true;
                        step = 2;
                        break block23;
                    } else {
                        if ((b & 0x20) != 0) {
                            maxDynamicTableSize = b & 0x1F;
                            if (maxDynamicTableSize == 31) {
                                step = 3;
                                break block23;
                            } else {
                                if (maxDynamicTableSize > hpack.maxDynamicTableSize) {
                                    return Decoder.error((Throwable)new HpackException("invalid max dynamic table size: " + maxDynamicTableSize));
                                }
                                hpack.encoderMaxDynamicTableSize = maxDynamicTableSize;
                                hpack.maxDynamicTableSizeChanged = false;
                                hpack.dynamicTable.setCapacity(maxDynamicTableSize);
                                continue;
                            }
                        }
                        step = 2;
                    }
                    break block23;
                }
                if (input.isDone()) {
                    if (headers != null) {
                        return Decoder.done((Object)((FingerTrieSeq)headers.bind()));
                    }
                    return Decoder.done((Object)FingerTrieSeq.empty());
                }
            }
            if (step == 2) {
                void headerDecoder2222;
                if (headerDecoder2222 == null) {
                    Decoder<HpackHeader> headerDecoder2222 = hpack.decodeHeader(input);
                } else {
                    Decoder headerDecoder2222 = headerDecoder2222.feed(input);
                }
                if (headerDecoder2222.isDone()) {
                    HpackHeader header = (HpackHeader)headerDecoder2222.bind();
                    Object headerDecoder2222 = null;
                    if (headers == null) {
                        headers = FingerTrieSeq.builder();
                    }
                    headers.add((Object)header);
                    if (indexed) {
                        hpack.dynamicTable.add(header);
                        indexed = false;
                    }
                    step = 1;
                    continue;
                }
                if (headerDecoder2222.isError()) {
                    return headerDecoder2222.asError();
                }
            }
            if (step != 3) break;
            while (input.isCont()) {
                b = input.head();
                input = input.step();
                if (shift == 28 && (b & 0xF8) != 0) {
                    return Decoder.error((Throwable)new DecoderException("max dynamic table size overflow"));
                }
                value |= (b & 0x7F) << shift;
                if ((b & 0x80) != 0) {
                    if ((shift += 7) < 32) continue;
                    return Decoder.error((Throwable)new DecoderException("max dynamic table size overflow"));
                }
                maxDynamicTableSize = 31 + value;
                if (maxDynamicTableSize < 0) {
                    return Decoder.error((Throwable)new HpackException("invalid max dynamic table size: " + maxDynamicTableSize));
                }
                hpack.encoderMaxDynamicTableSize = maxDynamicTableSize;
                hpack.maxDynamicTableSizeChanged = false;
                hpack.dynamicTable.setCapacity(maxDynamicTableSize);
                value = 0;
                shift = 0;
                step = 1;
                continue block0;
            }
            break;
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new HpackBlockDecoder(hpack, (Builder<HpackHeader, FingerTrieSeq<HpackHeader>>)headers, (Decoder<HpackHeader>)headerDecoder2222, indexed, value, shift, step);
    }

    static Decoder<FingerTrieSeq<HpackHeader>> decode(InputBuffer input, HpackDecoder hpack) {
        return HpackBlockDecoder.decode(input, hpack, null, null, false, 0, 0, 1);
    }
}

