/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import java.nio.charset.StandardCharsets;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public final class HpackHeader
implements Comparable<HpackHeader>,
Debug {
    final byte[] name;
    final byte[] value;
    final boolean sensitive;
    private static int hashSeed;
    static final int ENTRY_OVERHEAD = 32;
    static final byte[] EMPTY_VALUE;

    HpackHeader(byte[] name, byte[] value, boolean sensitive) {
        this.name = name;
        this.value = value;
        this.sensitive = sensitive;
    }

    public boolean isBlank() {
        return this.value.length == 0;
    }

    public String lowerCaseName() {
        return this.name().toLowerCase();
    }

    public String name() {
        return new String(this.name, StandardCharsets.UTF_8);
    }

    public int nameSize() {
        return this.name.length;
    }

    public String value() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public int valueSize() {
        return this.value.length;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    int hpackSize() {
        return this.name.length + this.value.length + 32;
    }

    @Override
    public int compareTo(HpackHeader that) {
        byte b2;
        byte b1;
        int i;
        int order = this.name.length - that.name.length;
        int n = Math.min(this.name.length, that.name.length);
        for (i = 0; i < n; ++i) {
            b1 = this.name[i];
            b2 = that.name[i];
            if (b1 == b2) continue;
            order = b1 - b2;
            break;
        }
        if (order == 0) {
            order = this.value.length - that.value.length;
            n = Math.min(this.value.length, that.value.length);
            for (i = 0; i < n; ++i) {
                b1 = this.value[i];
                b2 = that.value[i];
                if (b1 == b2) continue;
                order = b1 - b2;
                break;
            }
        }
        return order;
    }

    int compareName(byte[] name) {
        int order = this.name.length - name.length;
        int n = Math.min(this.name.length, name.length);
        for (int i = 0; i < n; ++i) {
            byte b1 = this.name[i];
            byte b2 = name[i];
            if (b1 == b2) continue;
            order = b1 - b2;
            break;
        }
        return order;
    }

    int compareValue(byte[] value) {
        int order = this.value.length - value.length;
        int n = Math.min(this.value.length, value.length);
        for (int i = 0; i < n; ++i) {
            byte b1 = this.value[i];
            byte b2 = value[i];
            if (b1 == b2) continue;
            order = b1 - b2;
            break;
        }
        return order;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HpackHeader) {
            HpackHeader that = (HpackHeader)other;
            int nameLength = this.name.length;
            int valueLength = this.value.length;
            if (nameLength == that.name.length && valueLength == that.value.length && this.sensitive == that.sensitive) {
                int i;
                byte b = 0;
                for (i = 0; i < nameLength; ++i) {
                    b = (byte)(b | (byte)(this.name[i] ^ that.name[i]));
                }
                for (i = 0; i < valueLength; ++i) {
                    b = (byte)(b | (byte)(this.value[i] ^ that.value[i]));
                }
                return b == 0;
            }
        }
        return false;
    }

    public boolean equalsName(byte[] name) {
        int nameLength = this.name.length;
        if (nameLength == name.length) {
            byte b = 0;
            for (int i = 0; i < nameLength; ++i) {
                b = (byte)(b | (byte)(this.name[i] ^ name[i]));
            }
            return b == 0;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HpackHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.mash((int)Murmur3.mix((int)0, (byte[])this.name, (int)0, (int)this.name.length))), (int)Murmur3.mash((int)Murmur3.mix((int)0, (byte[])this.value, (int)0, (int)this.value.length))), (int)Murmur3.hash((boolean)this.sensitive)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HpackHeader").write(46).write("create").write(40).debug((Object)this.name());
        if (this.value.length != 0 || this.sensitive) {
            output = output.write(", ").debug((Object)this.value());
        }
        if (this.sensitive) {
            output = output.write(", ").debug((Object)this.sensitive);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HpackHeader create(byte[] name, byte[] value, boolean sensitive) {
        return new HpackHeader(name, value, sensitive);
    }

    public static HpackHeader create(byte[] name, byte[] value) {
        return new HpackHeader(name, value, false);
    }

    public static HpackHeader create(String name, String value, boolean sensitive) {
        return new HpackHeader(name.getBytes(StandardCharsets.UTF_8), value.length() != 0 ? value.getBytes(StandardCharsets.UTF_8) : EMPTY_VALUE, sensitive);
    }

    public static HpackHeader create(String name, String value) {
        return new HpackHeader(name.getBytes(StandardCharsets.UTF_8), value.length() != 0 ? value.getBytes(StandardCharsets.UTF_8) : EMPTY_VALUE, false);
    }

    public static HpackHeader create(String name) {
        return new HpackHeader(name.getBytes(StandardCharsets.UTF_8), EMPTY_VALUE, false);
    }

    static {
        EMPTY_VALUE = new byte[0];
    }
}

