/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.OutputBuffer;

final class HpackStringEncoder
extends Encoder<Object, Object> {
    final Input string;
    final int length;
    final Output<?> huffmanOutput;
    final int value;
    final int step;

    HpackStringEncoder(Input string, int length, Output<?> huffmanOutput, int value, int step) {
        this.string = string;
        this.length = length;
        this.huffmanOutput = huffmanOutput;
        this.value = value;
        this.step = step;
    }

    HpackStringEncoder(Input string, int length, Output<?> huffmanOutput) {
        this(string, length, huffmanOutput, 0, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return HpackStringEncoder.encode(output, this.string.clone(), this.length, this.huffmanOutput != null ? this.huffmanOutput.clone() : null, this.value, this.step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, Input string, int length, Output<?> huffmanOutput, int value, int step) {
        if (step == 1 && output.isCont()) {
            int prefixMask;
            int n = prefixMask = huffmanOutput != null ? 128 : 0;
            if (length < 127) {
                output = output.write(prefixMask | length);
                step = 3;
            } else {
                output = output.write(prefixMask | 0x7F);
                value = length - 127;
                step = 2;
            }
        }
        if (step == 2) {
            while (output.isCont()) {
                if ((value & 0xFFFFFF80) != 0) {
                    output = output.write(0x80 | value & 0x7F);
                    value >>>= 7;
                    continue;
                }
                output = output.write(value);
                step = 3;
                break;
            }
        }
        if (step == 3) {
            int outputStart = output.index();
            int outputLimit = output.limit();
            int outputRemaining = outputLimit - outputStart;
            if (length < outputRemaining) {
                output = output.limit(outputStart + length);
            }
            if (huffmanOutput != null) {
                huffmanOutput = huffmanOutput.fork((Object)output);
                while (huffmanOutput.isCont() && string.isCont()) {
                    huffmanOutput = huffmanOutput.write(string.head());
                    string = string.step();
                }
                if (huffmanOutput.isCont() && !string.isCont()) {
                    huffmanOutput = huffmanOutput.flush();
                }
                huffmanOutput = huffmanOutput.fork((Object)Output.full());
            } else {
                while (output.isCont() && string.isCont()) {
                    output = output.write(string.head());
                    string = string.step();
                }
            }
            output = output.limit(outputLimit);
            length -= output.index() - outputStart;
            if (string.isError()) {
                return Encoder.error((Throwable)string.trap());
            }
            if (length == 0) {
                return Encoder.done();
            }
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HpackStringEncoder(string, length, huffmanOutput, value, step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, Input string, int length, Output<?> huffmanOutput) {
        return HpackStringEncoder.encode(output, string, length, huffmanOutput, 0, 1);
    }
}

