/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.hpack.HpackHeader;

final class HpackTableBuffer {
    HpackHeader[] headers;
    int head;
    int tail;
    int size;
    int capacity;

    HpackTableBuffer(HpackHeader[] headers, int head, int tail, int size, int capacity) {
        this.headers = headers;
        this.head = head;
        this.tail = tail;
        this.size = size;
        this.capacity = capacity;
    }

    int length() {
        int length = this.head - this.tail;
        if (length < 0) {
            length += this.headers.length;
        }
        return length;
    }

    int size() {
        return this.size;
    }

    int capacity() {
        return this.capacity;
    }

    void setCapacity(int capacity) {
        HpackHeader[] oldHeaders;
        this.capacity = capacity;
        if (capacity == 0) {
            this.clear();
        } else {
            while (this.size > capacity) {
                this.remove();
            }
        }
        int maxEntries = capacity / 32;
        if (capacity % 32 != 0) {
            ++maxEntries;
        }
        if ((oldHeaders = this.headers).length != maxEntries) {
            HpackHeader[] newHeaders = new HpackHeader[maxEntries];
            int n = this.length();
            int j = this.tail;
            for (int i = 0; i < n; ++i) {
                newHeaders[i] = oldHeaders[j];
                if (++j != oldHeaders.length) continue;
                j = 0;
            }
            this.headers = newHeaders;
            this.head = n;
            this.tail = 0;
        }
    }

    HpackHeader get(int index) {
        if (index <= 0 || index > this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        int i = this.head - index;
        if (i < 0) {
            return this.headers[i + this.headers.length];
        }
        return this.headers[i];
    }

    void add(HpackHeader header) {
        int headerSize = header.hpackSize();
        if (headerSize > this.capacity) {
            this.clear();
        } else {
            while (this.size + headerSize > this.capacity) {
                this.remove();
            }
            this.headers[this.head] = header;
            ++this.head;
            this.size += headerSize;
            if (this.head == this.headers.length) {
                this.head = 0;
            }
        }
    }

    HpackHeader remove() {
        HpackHeader header = this.headers[this.tail];
        if (header != null) {
            this.headers[this.tail] = null;
            ++this.tail;
            this.size -= header.hpackSize();
            if (this.tail == this.headers.length) {
                this.tail = 0;
            }
        }
        return header;
    }

    void clear() {
        while (this.tail != this.head) {
            this.headers[this.tail] = null;
            ++this.tail;
            if (this.tail != this.headers.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public HpackTableBuffer clone() {
        int tail;
        HpackHeader[] oldHeaders = this.headers;
        int n = oldHeaders.length;
        HpackHeader[] newHeaders = new HpackHeader[n];
        int head = this.head;
        int cursor = tail = this.tail;
        while (cursor != head) {
            newHeaders[cursor] = oldHeaders[cursor];
            if (++cursor != n) continue;
            cursor = 0;
        }
        return new HpackTableBuffer(newHeaders, head, tail, this.size, this.capacity);
    }

    static HpackTableBuffer withCapacity(int capacity) {
        int maxEntries = capacity / 32;
        if (capacity % 32 != 0) {
            ++maxEntries;
        }
        return new HpackTableBuffer(new HpackHeader[maxEntries], 0, 0, 0, capacity);
    }
}

