/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import java.nio.charset.StandardCharsets;
import swim.hpack.HpackHeader;

final class HpackTableStatic {
    final HpackHeader[] headers;
    private static HpackTableStatic standard;

    HpackTableStatic(HpackHeader[] headers) {
        this.headers = headers;
    }

    int length() {
        return this.headers.length;
    }

    HpackHeader get(int index) {
        return this.headers[index - 1];
    }

    int getIndex(byte[] name, byte[] value) {
        int lo = 0;
        int hi = this.headers.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            HpackHeader header = this.headers[mid];
            int order = -header.compareName(name);
            if (order == 0) {
                order = -header.compareValue(value);
            }
            if (order > 0) {
                lo = mid + 1;
                continue;
            }
            if (order < 0) {
                hi = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return -1;
    }

    int getIndex(byte[] name) {
        int lo = 0;
        int hi = this.headers.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            HpackHeader header = this.headers[mid];
            int order = -header.compareName(name);
            if (order > 0) {
                lo = mid + 1;
                continue;
            }
            if (order < 0) {
                hi = mid - 1;
                continue;
            }
            if (lo < hi) {
                hi = mid;
                continue;
            }
            return mid + 1;
        }
        return -1;
    }

    int getIndex(String name, String value) {
        return this.getIndex(name.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8));
    }

    int getIndex(String name) {
        return this.getIndex(name.getBytes(StandardCharsets.UTF_8));
    }

    static HpackTableStatic standard() {
        if (standard == null) {
            HpackHeader[] headers = new HpackHeader[]{HpackHeader.create(":authority"), HpackHeader.create(":method", "GET"), HpackHeader.create(":method", "POST"), HpackHeader.create(":path", "/"), HpackHeader.create(":path", "/index.html"), HpackHeader.create(":scheme", "http"), HpackHeader.create(":scheme", "https"), HpackHeader.create(":status", "200"), HpackHeader.create(":status", "204"), HpackHeader.create(":status", "206"), HpackHeader.create(":status", "304"), HpackHeader.create(":status", "400"), HpackHeader.create(":status", "404"), HpackHeader.create(":status", "500"), HpackHeader.create("accept-charset"), HpackHeader.create("accept-encoding", "gzip, deflate"), HpackHeader.create("accept-language"), HpackHeader.create("accept-ranges"), HpackHeader.create("accept"), HpackHeader.create("access-control-allow-origin"), HpackHeader.create("age"), HpackHeader.create("allow"), HpackHeader.create("authorization"), HpackHeader.create("cache-control"), HpackHeader.create("content-disposition"), HpackHeader.create("content-encoding"), HpackHeader.create("content-language"), HpackHeader.create("content-length"), HpackHeader.create("content-location"), HpackHeader.create("content-range"), HpackHeader.create("content-type"), HpackHeader.create("cookie"), HpackHeader.create("date"), HpackHeader.create("etag"), HpackHeader.create("expect"), HpackHeader.create("expires"), HpackHeader.create("from"), HpackHeader.create("host"), HpackHeader.create("if-match"), HpackHeader.create("if-modified-since"), HpackHeader.create("if-none-match"), HpackHeader.create("if-range"), HpackHeader.create("if-unmodified-since"), HpackHeader.create("last-modified"), HpackHeader.create("link"), HpackHeader.create("location"), HpackHeader.create("max-forwards"), HpackHeader.create("proxy-authenticate"), HpackHeader.create("proxy-authorization"), HpackHeader.create("range"), HpackHeader.create("referer"), HpackHeader.create("refresh"), HpackHeader.create("retry-after"), HpackHeader.create("server"), HpackHeader.create("set-cookie"), HpackHeader.create("strict-transport-security"), HpackHeader.create("transfer-encoding"), HpackHeader.create("user-agent"), HpackHeader.create("vary"), HpackHeader.create("via"), HpackHeader.create("www-authenticate")};
            standard = new HpackTableStatic(headers);
        }
        return standard;
    }
}

