/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.hpack.Huffman;

final class HuffmanEncodedOutput<T>
extends Output<T> {
    Output<T> output;
    int[] codes;
    byte[] lengths;
    long current;
    int bits;

    HuffmanEncodedOutput(Output<T> output, int[] codes, byte[] lengths, long current, int bits) {
        this.output = output;
        this.codes = codes;
        this.lengths = lengths;
        this.current = current;
        this.bits = bits;
    }

    HuffmanEncodedOutput(Output<T> output, int[] codes, byte[] lengths) {
        this(output, codes, lengths, 0L, 0);
    }

    HuffmanEncodedOutput(Output<T> output) {
        this(output, Huffman.CODES, Huffman.LENGTHS, 0L, 0);
    }

    public boolean isCont() {
        return this.output.isCont();
    }

    public boolean isFull() {
        return this.output.isFull();
    }

    public boolean isDone() {
        return this.output.isDone();
    }

    public boolean isError() {
        return false;
    }

    public boolean isPart() {
        return this.output.isPart();
    }

    public Output<T> isPart(boolean isPart) {
        this.output = this.output.isPart(isPart);
        return this;
    }

    public Output<T> write(int b) {
        while (this.bits >= 8) {
            this.bits -= 8;
            this.output = this.output.write((int)(this.current >> this.bits));
            if (this.output.isCont()) continue;
        }
        if (this.bits < 8) {
            int code = this.codes[b];
            byte length = this.lengths[b];
            this.current <<= length;
            this.current |= (long)code;
            this.bits += length;
            while (this.bits >= 8 && this.output.isCont()) {
                this.bits -= 8;
                this.output = this.output.write((int)(this.current >> this.bits));
            }
        }
        return this;
    }

    public Output<T> flush() {
        if (this.bits > 0) {
            this.current <<= 8 - this.bits;
            this.current |= (long)(255 >>> this.bits);
            this.bits -= 8;
            this.output = this.output.write((int)this.current);
            if (this.output.isError()) {
                return this.output;
            }
        }
        return this;
    }

    public OutputSettings settings() {
        return this.output.settings();
    }

    public Output<T> settings(OutputSettings settings) {
        this.output.settings(settings);
        return this;
    }

    public Output<T> fork(Object condition) {
        if (condition instanceof Output) {
            this.output = (Output)condition;
        }
        return this;
    }

    public T bind() {
        return (T)this.output.bind();
    }

    public Output<T> clone() {
        return new HuffmanEncodedOutput<T>(this.output.clone(), this.codes, this.lengths, this.current, this.bits);
    }
}

