/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import java.util.Iterator;
import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.hpack.HpackEncoder;
import swim.hpack.HpackHeader;

final class HpackBlockEncoder
extends Encoder<Object, Object> {
    final HpackEncoder hpack;
    final Iterator<HpackHeader> headers;
    final Encoder<?, ?> part;

    HpackBlockEncoder(HpackEncoder hpack, Iterator<HpackHeader> headers, Encoder<?, ?> part) {
        this.hpack = hpack;
        this.headers = headers;
        this.part = part;
    }

    HpackBlockEncoder(HpackEncoder hpack, Iterator<HpackHeader> headers) {
        this(hpack, headers, null);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return HpackBlockEncoder.encode(output, this.hpack, this.headers, this.part);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, HpackEncoder hpack, Iterator<HpackHeader> headers, Encoder<?, ?> part) {
        while (true) {
            if (part == null) {
                if (!headers.hasNext()) {
                    return Encoder.done();
                }
                part = hpack.encodeHeader(output, headers.next());
            } else {
                part = part.pull(output);
            }
            if (!part.isDone()) break;
            part = null;
        }
        if (part.isError()) {
            return part.asError();
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HpackBlockEncoder(hpack, headers, part);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, HpackEncoder hpack, Iterator<HpackHeader> headers) {
        return HpackBlockEncoder.encode(output, hpack, headers, null);
    }
}

