/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.hpack.HpackIndexing;

final class HpackHeaderEncoder
extends Encoder<Object, Object> {
    final int index;
    final Encoder<?, ?> nameEncoder;
    final Encoder<?, ?> valueEncoder;
    final HpackIndexing indexing;
    final int step;

    HpackHeaderEncoder(int index, Encoder<?, ?> nameEncoder, Encoder<?, ?> valueEncoder, HpackIndexing indexing, int step) {
        this.index = index;
        this.nameEncoder = nameEncoder;
        this.valueEncoder = valueEncoder;
        this.indexing = indexing;
        this.step = step;
    }

    HpackHeaderEncoder(int index, Encoder<?, ?> nameEncoder, Encoder<?, ?> valueEncoder, HpackIndexing indexing) {
        this(index, nameEncoder, valueEncoder, indexing, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return HpackHeaderEncoder.encode(output, this.index, this.nameEncoder, this.valueEncoder, this.indexing, this.step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, int index, Encoder<?, ?> nameEncoder, Encoder<?, ?> valueEncoder, HpackIndexing indexing, int step) {
        if (step == 1 && output.isCont()) {
            if (valueEncoder == null) {
                if (index < 127) {
                    output = output.write(0x80 | index);
                    return Encoder.done();
                }
                output = output.write(255);
                index -= 127;
                step = 2;
            } else if (indexing == HpackIndexing.INCREMENTAL) {
                if (index < 63) {
                    output = output.write(0x40 | index);
                    step = nameEncoder == null ? 4 : 3;
                } else {
                    output = output.write(127);
                    index -= 63;
                    step = 2;
                }
            } else if (indexing == HpackIndexing.NONE) {
                if (index < 15) {
                    output = output.write(0 | index);
                    step = 3;
                } else {
                    output = output.write(15);
                    index -= 15;
                    step = 2;
                }
            } else if (indexing == HpackIndexing.NEVER) {
                if (index < 15) {
                    output = output.write(0x10 | index);
                    step = 3;
                } else {
                    output = output.write(31);
                    index -= 15;
                    step = 2;
                }
            } else {
                throw new AssertionError();
            }
        }
        if (step == 2) {
            while (output.isCont()) {
                if ((index & 0xFFFFFF80) != 0) {
                    output = output.write(0x80 | index & 0x7F);
                    index >>>= 7;
                    continue;
                }
                if ((output = output.write(index)).isError()) {
                    return Encoder.error((Throwable)output.trap());
                }
                if (nameEncoder != null) {
                    step = 3;
                    continue;
                }
                if (valueEncoder != null) {
                    step = 4;
                    continue;
                }
                return Encoder.done();
            }
        }
        if (step == 3) {
            if ((nameEncoder = nameEncoder.pull(output)).isDone()) {
                step = 4;
            } else if (nameEncoder.isError()) {
                return nameEncoder.asError();
            }
        }
        if (step == 4) {
            if ((valueEncoder = valueEncoder.pull(output)).isDone()) {
                return Encoder.done();
            }
            if (valueEncoder.isError()) {
                return valueEncoder.asError();
            }
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HpackHeaderEncoder(index, nameEncoder, valueEncoder, indexing, step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, int index, Encoder<?, ?> nameEncoder, Encoder<?, ?> valueEncoder, HpackIndexing indexing) {
        return HpackHeaderEncoder.encode(output, index, nameEncoder, valueEncoder, indexing, 1);
    }
}

