/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;

final class HpackIntegerEncoder
extends Encoder<Object, Object> {
    final int prefixMask;
    final int prefixBits;
    final int value;
    final int step;

    HpackIntegerEncoder(int prefixMask, int prefixBits, int value, int step) {
        this.prefixMask = prefixMask;
        this.prefixBits = prefixBits;
        this.value = value;
        this.step = step;
    }

    HpackIntegerEncoder(int prefixMask, int prefixBits, int value) {
        this(prefixMask, prefixBits, value, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return HpackIntegerEncoder.encode(output, this.prefixMask, this.prefixBits, this.value, this.step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, int prefixMask, int prefixBits, int value, int step) {
        if (step == 1 && output.isCont()) {
            int prefixFill = (1 << prefixBits) - 1;
            if (value < prefixFill) {
                output = output.write(prefixMask | value);
                return Encoder.done();
            }
            output = output.write(prefixMask | prefixFill);
            value -= prefixFill;
            step = 2;
        }
        if (step == 2) {
            while (output.isCont()) {
                if ((value & 0xFFFFFF80) != 0) {
                    output = output.write(0x80 | value & 0x7F);
                    value >>>= 7;
                    continue;
                }
                if ((output = output.write(value)).isError()) {
                    return Encoder.error((Throwable)output.trap());
                }
                return Encoder.done();
            }
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HpackIntegerEncoder(prefixMask, prefixBits, value, step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, int prefixMask, int prefixBits, int value) {
        return HpackIntegerEncoder.encode(output, prefixMask, prefixBits, value, 1);
    }
}

