/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

import swim.codec.Input;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;
import swim.hpack.Huffman;
import swim.hpack.HuffmanTree;

final class HuffmanDecodedInput
extends Input {
    Input input;
    HuffmanTree root;
    HuffmanTree node;
    int current;
    int bits;
    int head;
    int state;
    Throwable error;
    private static final int DECODE = 0;
    private static final int FINISH = 1;
    private static final int CONT = 2;
    private static final int EMPTY = 3;
    private static final int DONE = 4;
    private static final int ERROR = 5;

    HuffmanDecodedInput(Input input, HuffmanTree root, HuffmanTree node, int current, int bits, int head, int state, Throwable error) {
        this.input = input;
        this.root = root;
        this.node = node;
        this.current = current;
        this.bits = bits;
        this.head = head;
        this.state = state;
        this.error = error;
    }

    HuffmanDecodedInput(Input input) {
        this(input, Huffman.tree(), Huffman.tree(), 0, 0, -1, 0, null);
    }

    public boolean isCont() {
        return this.state() == 2;
    }

    public boolean isEmpty() {
        return this.state() == 3;
    }

    public boolean isDone() {
        return this.state() == 4;
    }

    public boolean isError() {
        return this.state() == 5;
    }

    public boolean isPart() {
        return this.input.isPart();
    }

    public Input isPart(boolean isPart) {
        this.input = this.input.isPart(isPart);
        return this;
    }

    int state() {
        int c;
        block15: {
            if (this.head < 0 && this.state == 0) {
                while (true) {
                    if (this.bits >= 8) {
                        c = this.current >>> this.bits - 8 & 0xFF;
                        this.node = this.node.children[c];
                        this.bits -= this.node.bits;
                        if (!this.node.isTerminal()) continue;
                        if (this.node.symbol == 256) {
                            this.state = 5;
                            this.error = new InputException("unexpected EOS symbol");
                        } else {
                            this.head = this.node.symbol;
                            this.state = 2;
                            this.node = this.root;
                        }
                        break block15;
                    }
                    if (!this.input.isCont()) break;
                    int b = this.input.head();
                    this.input = this.input.step();
                    this.current = this.current << 8 | b;
                    this.bits += 8;
                }
                if (this.input.isEmpty()) {
                    this.state = 3;
                } else if (this.input.isDone()) {
                    this.state = 1;
                } else if (this.input.isError()) {
                    this.state = 5;
                    this.error = this.input.trap();
                }
            }
        }
        if (this.head < 0 && this.state == 1 && this.bits > 0) {
            c = this.current << 8 - this.bits & 0xFF;
            this.node = this.node.children[c];
            if (this.node.isTerminal() && this.node.bits <= this.bits) {
                this.bits -= this.node.bits;
                this.head = this.node.symbol;
                this.state = 2;
                this.node = this.root;
            } else {
                int mask = (1 << this.bits) - 1;
                if ((this.current & mask) != mask) {
                    this.state = 5;
                    this.error = new InputException("invalid padding");
                } else {
                    this.state = 4;
                }
            }
        }
        return this.state;
    }

    public int head() {
        int head = this.head;
        if (head < 0) {
            throw new InputException();
        }
        return head;
    }

    public Input step() {
        if (this.head >= 0) {
            this.head = -1;
            this.state = 0;
            return this;
        }
        InputException error = new InputException("invalid step");
        return Input.error((Throwable)error, (Object)this.input.id(), (Mark)this.mark(), (InputSettings)this.input.settings());
    }

    public Input fork(Object condition) {
        if (condition instanceof Input) {
            this.input = (Input)condition;
            this.state = 0;
        }
        return this;
    }

    public Throwable trap() {
        if (this.state() == 5) {
            return this.error;
        }
        throw new IllegalStateException();
    }

    public Input seek(Mark mark) {
        this.input = this.input.seek(mark);
        this.state = 0;
        this.error = null;
        return this;
    }

    public Object id() {
        return this.input.id();
    }

    public Input id(Object id) {
        this.input = this.input.id(id);
        return this;
    }

    public Mark mark() {
        return this.input.mark();
    }

    public Input mark(Mark mark) {
        this.input = this.input.mark(mark);
        return this;
    }

    public long offset() {
        return this.input.offset();
    }

    public int line() {
        return this.input.line();
    }

    public int column() {
        return this.input.column();
    }

    public InputSettings settings() {
        return this.input.settings();
    }

    public Input settings(InputSettings settings) {
        this.input = this.input.settings(settings);
        return this;
    }

    public Input clone() {
        return new HuffmanDecodedInput(this.input.clone(), this.root, this.node, this.current, this.bits, this.state, this.head, this.error);
    }
}

