/*
 * Decompiled with CFR 0.152.
 */
package swim.hpack;

final class HuffmanTree {
    final int symbol;
    final int bits;
    final HuffmanTree[] children;

    private HuffmanTree(int symbol, int bits) {
        assert (0 < bits && bits <= 8);
        this.symbol = symbol;
        this.bits = bits;
        this.children = null;
    }

    private HuffmanTree() {
        this.symbol = 0;
        this.bits = 8;
        this.children = new HuffmanTree[256];
    }

    boolean isTerminal() {
        return this.children == null;
    }

    static HuffmanTree build(int[] codes, byte[] lengths) {
        HuffmanTree root = new HuffmanTree();
        for (int i = 0; i < codes.length; ++i) {
            HuffmanTree.insert(root, i, codes[i], lengths[i]);
        }
        return root;
    }

    private static void insert(HuffmanTree root, int symbol, int code, byte length) {
        HuffmanTree current = root;
        while (length > 8) {
            if (current.isTerminal()) {
                throw new IllegalStateException("non-unique Huffman code prefix");
            }
            int i = code >>> (length = (byte)(length - 8)) & 0xFF;
            if (current.children[i] == null) {
                current.children[i] = new HuffmanTree();
            }
            current = current.children[i];
        }
        HuffmanTree terminal = new HuffmanTree(symbol, length);
        int shift = 8 - length;
        int start = code << shift & 0xFF;
        int end = 1 << shift;
        for (int i = start; i < start + end; ++i) {
            current.children[i] = terminal;
        }
    }
}

