/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.codec.Decoder;
import swim.io.FlowContext;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpContext;
import swim.io.IpSocket;
import swim.io.mqtt.MqttSettings;
import swim.io.mqtt.MqttSocket;
import swim.io.mqtt.MqttSocketContext;
import swim.mqtt.MqttPacket;

public abstract class AbstractMqttSocket<I, O>
implements MqttSocket<I, O>,
IpContext,
FlowContext {
    protected MqttSocketContext<I, O> context;

    @Override
    public MqttSocketContext<I, O> mqttSocketContext() {
        return this.context;
    }

    @Override
    public void setMqttSocketContext(MqttSocketContext<I, O> context) {
        this.context = context;
    }

    @Override
    public long idleTimeout() {
        return -1L;
    }

    @Override
    public void doRead() {
    }

    @Override
    public void didRead(MqttPacket<? extends I> packet) {
    }

    @Override
    public void doWrite() {
    }

    @Override
    public void didWrite(MqttPacket<? extends O> packet) {
    }

    @Override
    public void willConnect() {
    }

    @Override
    public void didConnect() {
    }

    @Override
    public void willSecure() {
    }

    @Override
    public void didSecure() {
    }

    @Override
    public void willBecome(IpSocket socket) {
    }

    @Override
    public void didBecome(IpSocket socket) {
    }

    @Override
    public void didTimeout() {
    }

    @Override
    public void didDisconnect() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public boolean isConnected() {
        return this.context.isConnected();
    }

    public boolean isClient() {
        return this.context.isClient();
    }

    public boolean isServer() {
        return this.context.isServer();
    }

    public boolean isSecure() {
        return this.context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    public MqttSettings mqttSettings() {
        return this.context.mqttSettings();
    }

    public <I2 extends I> void read(Decoder<I2> content) {
        this.context.read(content);
    }

    public <O2 extends O> void write(MqttPacket<O2> packet) {
        this.context.write(packet);
    }

    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    public void close() {
        this.context.close();
    }
}

