/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.IpSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.io.mqtt.MqttSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class MqttSettings
implements Debug {
    private static int hashSeed;
    private static MqttSettings standard;
    private static Form<MqttSettings> form;
    protected final IpSettings ipSettings;
    protected final int maxPayloadSize;

    public MqttSettings(IpSettings ipSettings, int maxPayloadSize) {
        this.ipSettings = ipSettings;
        this.maxPayloadSize = maxPayloadSize;
    }

    public static MqttSettings standard() {
        if (standard == null) {
            int maxPayloadSize;
            try {
                maxPayloadSize = Integer.parseInt(System.getProperty("swim.mqtt.max.payload.size"));
            }
            catch (NumberFormatException error) {
                maxPayloadSize = 0x1000000;
            }
            standard = new MqttSettings(IpSettings.standard(), maxPayloadSize);
        }
        return standard;
    }

    public static MqttSettings from(IpSettings ipSettings) {
        return MqttSettings.standard().ipSettings(ipSettings);
    }

    @Kind
    public static Form<MqttSettings> form() {
        if (form == null) {
            form = new MqttSettingsForm();
        }
        return form;
    }

    public final IpSettings ipSettings() {
        return this.ipSettings;
    }

    public MqttSettings ipSettings(IpSettings ipSettings) {
        return this.copy(ipSettings, this.maxPayloadSize);
    }

    public final TlsSettings tlsSettings() {
        return this.ipSettings.tlsSettings();
    }

    public MqttSettings tlsSettings(TlsSettings tlsSettings) {
        return this.ipSettings(this.ipSettings.tlsSettings(tlsSettings));
    }

    public final TcpSettings tcpSettings() {
        return this.ipSettings.tcpSettings();
    }

    public MqttSettings tcpSettings(TcpSettings tcpSettings) {
        return this.ipSettings(this.ipSettings.tcpSettings(tcpSettings));
    }

    public final int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public MqttSettings maxPayloadSize(int maxPayloadSize) {
        return this.copy(this.ipSettings, maxPayloadSize);
    }

    protected MqttSettings copy(IpSettings ipSettings, int maxPayloadSize) {
        return new MqttSettings(ipSettings, maxPayloadSize);
    }

    public Value toValue() {
        return MqttSettings.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSettings) {
            MqttSettings that = (MqttSettings)other;
            return this.ipSettings.equals((Object)that.ipSettings) && this.maxPayloadSize == that.maxPayloadSize;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.ipSettings.hashCode()), (int)this.maxPayloadSize));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttSettings").write(46).write("standard").write(40).write(41).write(46).write("ipSettings").write(40).debug((Object)this.ipSettings).write(41).write(46).write("maxPayloadSize").write(40).debug((Object)this.maxPayloadSize).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

