/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.codec.Decoder;
import swim.concurrent.Conts;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpModem;
import swim.io.IpModemContext;
import swim.io.IpSocket;
import swim.io.mqtt.MqttSettings;
import swim.io.mqtt.MqttSocket;
import swim.io.mqtt.MqttSocketContext;
import swim.mqtt.Mqtt;
import swim.mqtt.MqttPacket;

public class MqttSocketModem<I, O>
implements IpModem<Object, Object>,
MqttSocketContext<I, O> {
    protected final MqttSocket<I, O> socket;
    protected final MqttSettings mqttSettings;
    protected IpModemContext<Object, Object> context;

    public MqttSocketModem(MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        this.socket = socket;
        this.mqttSettings = mqttSettings;
    }

    public IpModemContext<Object, Object> ipModemContext() {
        return this.context;
    }

    public void setIpModemContext(IpModemContext<Object, Object> context) {
        this.context = context;
        this.socket.setMqttSocketContext(this);
    }

    public long idleTimeout() {
        return this.socket.idleTimeout();
    }

    public void doRead() {
        this.socket.doRead();
    }

    public void didRead(Object input) {
        this.socket.didRead((MqttPacket)input);
    }

    public void doWrite() {
        this.socket.doWrite();
    }

    public void didWrite(Object output) {
        this.socket.didWrite((MqttPacket)output);
    }

    public void willConnect() {
        this.socket.willConnect();
    }

    public void didConnect() {
        this.socket.didConnect();
    }

    public void willSecure() {
        this.socket.willSecure();
    }

    public void didSecure() {
        this.socket.didSecure();
    }

    public void willBecome(IpSocket socket) {
        this.socket.willBecome(socket);
    }

    public void didBecome(IpSocket socket) {
        this.socket.didBecome(socket);
    }

    public void didTimeout() {
        this.socket.didTimeout();
    }

    public void didDisconnect() {
        this.socket.didDisconnect();
    }

    public void didFail(Throwable error) {
        Throwable failure = null;
        try {
            this.socket.didFail(error);
        }
        catch (Throwable cause) {
            if (!Conts.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.close();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    public boolean isConnected() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isConnected();
    }

    public boolean isClient() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isClient();
    }

    public boolean isServer() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isServer();
    }

    public boolean isSecure() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public MqttSettings mqttSettings() {
        return this.mqttSettings;
    }

    @Override
    public <I2 extends I> void read(Decoder<I2> content) {
        this.context.read(Mqtt.standardDecoder().packetDecoder(content));
    }

    @Override
    public <O2 extends O> void write(MqttPacket<O2> packet) {
        this.context.write(packet.mqttEncoder(Mqtt.standardEncoder()));
    }

    @Override
    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    @Override
    public void close() {
        this.context.close();
    }
}

