/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import java.net.InetSocketAddress;
import swim.io.IpInterface;
import swim.io.IpServiceRef;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.IpSocketRef;
import swim.io.mqtt.MqttService;
import swim.io.mqtt.MqttSettings;
import swim.io.mqtt.MqttSocket;
import swim.io.mqtt.MqttSocketModem;
import swim.io.mqtt.MqttSocketService;

public interface MqttInterface
extends IpInterface {
    public MqttSettings mqttSettings();

    default public IpServiceRef bindMqtt(InetSocketAddress localAddress, MqttService service, MqttSettings mqttSettings) {
        MqttSocketService tcpService = new MqttSocketService(service, mqttSettings);
        return this.bindTcp(localAddress, tcpService, mqttSettings.ipSettings());
    }

    default public IpServiceRef bindMqtt(InetSocketAddress localAddress, MqttService service) {
        return this.bindMqtt(localAddress, service, this.mqttSettings());
    }

    default public IpServiceRef bindMqtt(String address, int port, MqttService service, MqttSettings mqttSettings) {
        return this.bindMqtt(new InetSocketAddress(address, port), service, mqttSettings);
    }

    default public IpServiceRef bindMqtt(String address, int port, MqttService service) {
        return this.bindMqtt(new InetSocketAddress(address, port), service, this.mqttSettings());
    }

    default public IpServiceRef bindMqtts(InetSocketAddress localAddress, MqttService service, MqttSettings mqttSettings) {
        MqttSocketService tlsService = new MqttSocketService(service, mqttSettings);
        return this.bindTls(localAddress, tlsService, mqttSettings.ipSettings());
    }

    default public IpServiceRef bindMqtts(InetSocketAddress localAddress, MqttService service) {
        return this.bindMqtts(localAddress, service, this.mqttSettings());
    }

    default public IpServiceRef bindMqtts(String address, int port, MqttService service, MqttSettings mqttSettings) {
        return this.bindMqtts(new InetSocketAddress(address, port), service, mqttSettings);
    }

    default public IpServiceRef bindMqtts(String address, int port, MqttService service) {
        return this.bindMqtts(new InetSocketAddress(address, port), service, this.mqttSettings());
    }

    default public <I, O> IpSocketRef connectMqtt(InetSocketAddress localAddress, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        MqttSocketModem<I, O> modem = new MqttSocketModem<I, O>(socket, mqttSettings);
        IpSocketModem tcpSocket = new IpSocketModem(modem);
        return this.connectTcp(localAddress, (IpSocket)tcpSocket, mqttSettings.ipSettings());
    }

    default public <I, O> IpSocketRef connectMqtt(InetSocketAddress localAddress, MqttSocket<I, O> socket) {
        return this.connectMqtt(localAddress, socket, this.mqttSettings());
    }

    default public <I, O> IpSocketRef connectMqtt(String address, int port, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        return this.connectMqtt(new InetSocketAddress(address, port), socket, mqttSettings);
    }

    default public <I, O> IpSocketRef connectMqtt(String address, int port, MqttSocket<I, O> socket) {
        return this.connectMqtt(new InetSocketAddress(address, port), socket, this.mqttSettings());
    }

    default public <I, O> IpSocketRef connectMqtts(InetSocketAddress localAddress, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        MqttSocketModem<I, O> modem = new MqttSocketModem<I, O>(socket, mqttSettings);
        IpSocketModem tlsSocket = new IpSocketModem(modem);
        return this.connectTls(localAddress, (IpSocket)tlsSocket, mqttSettings.ipSettings());
    }

    default public <I, O> IpSocketRef connectMqtts(InetSocketAddress localAddress, MqttSocket<I, O> socket) {
        return this.connectMqtts(localAddress, socket, this.mqttSettings());
    }

    default public <I, O> IpSocketRef connectMqtts(String address, int port, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        return this.connectMqtts(new InetSocketAddress(address, port), socket, mqttSettings);
    }

    default public <I, O> IpSocketRef connectMqtts(String address, int port, MqttSocket<I, O> socket) {
        return this.connectMqtts(new InetSocketAddress(address, port), socket, this.mqttSettings());
    }
}

