/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import java.net.InetSocketAddress;
import swim.concurrent.Stage;
import swim.io.Endpoint;
import swim.io.Service;
import swim.io.ServiceRef;
import swim.io.Socket;
import swim.io.SocketModem;
import swim.io.SocketRef;
import swim.io.mqtt.MqttService;
import swim.io.mqtt.MqttSettings;
import swim.io.mqtt.MqttSocket;
import swim.io.mqtt.MqttSocketModem;
import swim.io.mqtt.MqttSocketService;

public class MqttEndpoint {
    protected final Endpoint endpoint;
    protected MqttSettings mqttSettings;

    public MqttEndpoint(Endpoint endpoint, MqttSettings mqttSettings) {
        this.endpoint = endpoint;
        this.mqttSettings = mqttSettings;
    }

    public MqttEndpoint(Endpoint endpoint) {
        this(endpoint, MqttSettings.standard());
    }

    public MqttEndpoint(Stage stage, MqttSettings mqttSettings) {
        this(new Endpoint(stage), mqttSettings);
    }

    public MqttEndpoint(Stage stage) {
        this(new Endpoint(stage), MqttSettings.standard());
    }

    public final MqttSettings mqttSettings() {
        return this.mqttSettings;
    }

    public final Stage stage() {
        return this.endpoint.stage();
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public void start() {
        this.endpoint.start();
    }

    public void stop() {
        this.endpoint.stop();
    }

    public ServiceRef bindMqtt(InetSocketAddress localAddress, MqttService service, MqttSettings mqttSettings) {
        MqttSocketService tcpService = new MqttSocketService(service, mqttSettings);
        return this.endpoint.bindTcp(localAddress, (Service)tcpService, mqttSettings.socketSettings());
    }

    public ServiceRef bindMqtt(InetSocketAddress localAddress, MqttService service) {
        return this.bindMqtt(localAddress, service, this.mqttSettings);
    }

    public ServiceRef bindMqtt(String address, int port, MqttService service, MqttSettings mqttSettings) {
        return this.bindMqtt(new InetSocketAddress(address, port), service, mqttSettings);
    }

    public ServiceRef bindMqtt(String address, int port, MqttService service) {
        return this.bindMqtt(new InetSocketAddress(address, port), service, this.mqttSettings);
    }

    public ServiceRef bindMqtts(InetSocketAddress localAddress, MqttService service, MqttSettings mqttSettings) {
        MqttSocketService tlsService = new MqttSocketService(service, mqttSettings);
        return this.endpoint.bindTls(localAddress, (Service)tlsService, mqttSettings.socketSettings());
    }

    public ServiceRef bindMqtts(InetSocketAddress localAddress, MqttService service) {
        return this.bindMqtts(localAddress, service, this.mqttSettings);
    }

    public ServiceRef bindMqtts(String address, int port, MqttService service, MqttSettings mqttSettings) {
        return this.bindMqtts(new InetSocketAddress(address, port), service, mqttSettings);
    }

    public ServiceRef bindMqtts(String address, int port, MqttService service) {
        return this.bindMqtts(new InetSocketAddress(address, port), service, this.mqttSettings);
    }

    public <I, O> SocketRef connectMqtt(InetSocketAddress localAddress, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        MqttSocketModem<I, O> modem = new MqttSocketModem<I, O>(socket, mqttSettings);
        SocketModem tcpSocket = new SocketModem(modem);
        return this.endpoint.connectTcp(localAddress, (Socket)tcpSocket, mqttSettings.socketSettings());
    }

    public <I, O> SocketRef connectMqtt(InetSocketAddress localAddress, MqttSocket<I, O> socket) {
        return this.connectMqtt(localAddress, socket, this.mqttSettings);
    }

    public <I, O> SocketRef connectMqtt(String address, int port, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        return this.connectMqtt(new InetSocketAddress(address, port), socket, mqttSettings);
    }

    public <I, O> SocketRef connectMqtt(String address, int port, MqttSocket<I, O> socket) {
        return this.connectMqtt(new InetSocketAddress(address, port), socket, this.mqttSettings);
    }

    public <I, O> SocketRef connectMqtts(InetSocketAddress localAddress, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        MqttSocketModem<I, O> modem = new MqttSocketModem<I, O>(socket, mqttSettings);
        SocketModem tlsSocket = new SocketModem(modem);
        return this.endpoint.connectTls(localAddress, (Socket)tlsSocket, mqttSettings.socketSettings());
    }

    public <I, O> SocketRef connectMqtts(InetSocketAddress localAddress, MqttSocket<I, O> socket) {
        return this.connectMqtts(localAddress, socket, this.mqttSettings);
    }

    public <I, O> SocketRef connectMqtts(String address, int port, MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        return this.connectMqtts(new InetSocketAddress(address, port), socket, mqttSettings);
    }

    public <I, O> SocketRef connectMqtts(String address, int port, MqttSocket<I, O> socket) {
        return this.connectMqtts(new InetSocketAddress(address, port), socket, this.mqttSettings);
    }
}

