/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import swim.concurrent.Stage;
import swim.io.IpSettings;
import swim.io.IpStation;
import swim.io.Station;
import swim.io.mqtt.MqttInterface;
import swim.io.mqtt.MqttSettings;

public class MqttEndpoint
implements IpStation,
MqttInterface {
    protected final Station station;
    protected MqttSettings mqttSettings;

    public MqttEndpoint(Station station, MqttSettings mqttSettings) {
        this.station = station;
        this.mqttSettings = mqttSettings;
    }

    public MqttEndpoint(Station station) {
        this(station, MqttSettings.standard());
    }

    public MqttEndpoint(Stage stage, MqttSettings mqttSettings) {
        this(new Station(stage), mqttSettings);
    }

    public MqttEndpoint(Stage stage) {
        this(new Station(stage), MqttSettings.standard());
    }

    public final Stage stage() {
        return this.station.stage();
    }

    public final Station station() {
        return this.station;
    }

    public final IpSettings ipSettings() {
        return this.mqttSettings.ipSettings();
    }

    @Override
    public final MqttSettings mqttSettings() {
        return this.mqttSettings;
    }

    public void start() {
        this.station.start();
    }

    public void stop() {
        this.station.stop();
    }
}

