/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import java.net.InetSocketAddress;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpService;
import swim.io.IpServiceContext;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.mqtt.MqttService;
import swim.io.mqtt.MqttServiceContext;
import swim.io.mqtt.MqttSettings;
import swim.io.mqtt.MqttSocket;
import swim.io.mqtt.MqttSocketModem;

public class MqttSocketService
implements IpService,
MqttServiceContext {
    protected final MqttService service;
    protected final MqttSettings mqttSettings;
    protected IpServiceContext context;

    public MqttSocketService(MqttService service, MqttSettings mqttSettings) {
        this.service = service;
        this.mqttSettings = mqttSettings;
    }

    public IpServiceContext ipServiceContext() {
        return this.context;
    }

    public void setIpServiceContext(IpServiceContext context) {
        this.context = context;
        this.service.setMqttServiceContext(this);
    }

    public IpSocket createSocket() {
        MqttSocket<?, ?> socket = this.service.createSocket();
        MqttSocketModem modem = new MqttSocketModem(socket, this.mqttSettings);
        return new IpSocketModem(modem);
    }

    public void didBind() {
        this.service.didBind();
    }

    public void didAccept(IpSocket socket) {
        if (socket instanceof MqttSocketModem) {
            this.service.didAccept(((MqttSocketModem)socket).socket);
        }
    }

    public void didUnbind() {
        this.service.didUnbind();
    }

    public void didFail(Throwable error) {
        this.service.didFail(error);
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public MqttSettings mqttSettings() {
        return this.mqttSettings;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    @Override
    public void unbind() {
        this.context.unbind();
    }
}

