/*
 * Decompiled with CFR 0.152.
 */
package swim.io.warp;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.concurrent.PullRequest;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowContext;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpContext;
import swim.io.IpSocket;
import swim.io.warp.WarpSettings;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpSocketContext;
import swim.warp.Envelope;
import swim.ws.WsCloseFrame;
import swim.ws.WsControlFrame;
import swim.ws.WsPingFrame;
import swim.ws.WsPongFrame;

public abstract class AbstractWarpSocket
implements WarpSocket,
IpContext,
FlowContext {
    protected WarpSocketContext context;

    @Override
    public WarpSocketContext warpSocketContext() {
        return this.context;
    }

    @Override
    public void setWarpSocketContext(WarpSocketContext context) {
        this.context = context;
    }

    @Override
    public long idleTimeout() {
        return -1L;
    }

    @Override
    public void doRead() {
    }

    @Override
    public void didRead(Envelope envelope) {
    }

    @Override
    public void didRead(WsControlFrame<?, ?> frame) {
        if (frame instanceof WsPingFrame) {
            this.write((WsControlFrame<?, ? extends Envelope>)WsPongFrame.create((Object)frame.payloadValue()));
        } else if (frame instanceof WsCloseFrame) {
            this.close();
        }
    }

    @Override
    public void doWrite() {
    }

    @Override
    public void didWrite(Envelope envelope) {
    }

    @Override
    public void didWrite(WsControlFrame<?, ?> frame) {
        if (frame instanceof WsCloseFrame) {
            this.close();
        }
    }

    @Override
    public void didUpgrade(HttpRequest<?> httpRequest, HttpResponse<?> httpResponse) {
    }

    @Override
    public void willConnect() {
    }

    @Override
    public void didConnect() {
    }

    @Override
    public void willSecure() {
    }

    @Override
    public void didSecure() {
    }

    @Override
    public void willBecome(IpSocket socket) {
    }

    @Override
    public void didBecome(IpSocket socket) {
    }

    @Override
    public void didTimeout() {
    }

    @Override
    public void didDisconnect() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public boolean isConnected() {
        return this.context.isConnected();
    }

    public boolean isClient() {
        return this.context.isClient();
    }

    public boolean isServer() {
        return this.context.isServer();
    }

    public boolean isSecure() {
        return this.context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    public WarpSettings warpSettings() {
        return this.context.warpSettings();
    }

    public void feed(PullRequest<Envelope> pullRequest) {
        this.context.feed(pullRequest);
    }

    public void feed(Envelope envelope, float prio) {
        this.context.feed(envelope, prio);
    }

    public void feed(Envelope envelope) {
        this.context.feed(envelope);
    }

    public void write(WsControlFrame<?, ? extends Envelope> frame) {
        this.context.write(frame);
    }

    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    public void close() {
        this.context.close();
    }
}

