/*
 * Decompiled with CFR 0.152.
 */
package swim.io.ws;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.codec.Decoder;
import swim.concurrent.Cont;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpModem;
import swim.io.IpModemContext;
import swim.io.IpSocket;
import swim.io.ws.WebSocket;
import swim.io.ws.WebSocketContext;
import swim.io.ws.WsSettings;
import swim.ws.WsControlFrame;
import swim.ws.WsDataFrame;
import swim.ws.WsDecoder;
import swim.ws.WsEncoder;
import swim.ws.WsFrame;
import swim.ws.WsOpcode;

public class WebSocketModem<I, O>
implements IpModem<Object, Object>,
WebSocketContext<I, O> {
    protected final WebSocket<I, O> socket;
    protected final WsSettings wsSettings;
    protected final WsDecoder decoder;
    protected final WsEncoder encoder;
    protected IpModemContext<Object, Object> context;

    public WebSocketModem(WebSocket<I, O> socket, WsSettings wsSettings, WsDecoder decoder, WsEncoder encoder) {
        this.socket = socket;
        this.wsSettings = wsSettings;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public IpModemContext<Object, Object> ipModemContext() {
        return this.context;
    }

    public void setIpModemContext(IpModemContext<Object, Object> context) {
        this.context = context;
        this.socket.setWebSocketContext(this);
    }

    public long idleTimeout() {
        return this.socket.idleTimeout();
    }

    public void doRead() {
        this.socket.doRead();
    }

    public void didRead(Object input) {
        this.socket.didRead((WsFrame)input);
    }

    public void doWrite() {
        this.socket.doWrite();
    }

    public void didWrite(Object output) {
        this.socket.didWrite((WsFrame)output);
    }

    public void willConnect() {
        this.socket.willConnect();
    }

    public void didConnect() {
        this.socket.didConnect();
    }

    public void willSecure() {
        this.socket.willSecure();
    }

    public void didSecure() {
        this.socket.didSecure();
    }

    public void willBecome(IpSocket socket) {
        this.socket.willBecome(socket);
    }

    public void didBecome(IpSocket socket) {
        this.socket.didBecome(socket);
    }

    public void didTimeout() {
        this.socket.didTimeout();
    }

    public void didDisconnect() {
        this.socket.didDisconnect();
    }

    public void didFail(Throwable error) {
        Throwable failure = null;
        try {
            this.socket.didFail(error);
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.close();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    public boolean isConnected() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isConnected();
    }

    public boolean isClient() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isClient();
    }

    public boolean isServer() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isServer();
    }

    public boolean isSecure() {
        IpModemContext<Object, Object> context = this.context;
        return context != null && context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public WsSettings wsSettings() {
        return this.wsSettings;
    }

    @Override
    public <I2 extends I> void read(Decoder<I2> payloadDecoder) {
        this.context.read(this.decoder.messageDecoder(payloadDecoder));
    }

    @Override
    public <I2 extends I> void read(WsOpcode frameType, Decoder<I2> payloadDecoder) {
        this.context.read(this.decoder.continuationDecoder(frameType, payloadDecoder));
    }

    @Override
    public <O2 extends O> void write(WsDataFrame<O2> frame) {
        this.context.write(this.encoder.frameEncoder(frame));
    }

    @Override
    public <O2 extends O> void write(WsControlFrame<?, O2> frame) {
        this.context.write(this.encoder.frameEncoder(frame));
    }

    @Override
    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    @Override
    public void close() {
        this.context.close();
    }
}

