/*
 * Decompiled with CFR 0.152.
 */
package swim.io.ws;

import swim.codec.Output;
import swim.io.IpSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.io.http.HttpSettings;
import swim.io.ws.WsSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;
import swim.ws.WsEngineSettings;

public class WsSettings
extends WsEngineSettings {
    protected final HttpSettings httpSettings;
    private static int hashSeed;
    private static WsSettings standard;
    private static Form<WsSettings> form;

    public WsSettings(HttpSettings httpSettings, int maxFrameSize, int maxMessageSize, int serverCompressionLevel, int clientCompressionLevel, boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits, boolean autoClose) {
        super(maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits, autoClose);
        this.httpSettings = httpSettings;
    }

    public final HttpSettings httpSettings() {
        return this.httpSettings;
    }

    public WsSettings httpSettings(HttpSettings httpSettings) {
        return this.copy(httpSettings, this.maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits, this.autoClose);
    }

    public final IpSettings ipSettings() {
        return this.httpSettings.ipSettings();
    }

    public WsSettings ipSettings(IpSettings ipSettings) {
        return this.httpSettings(this.httpSettings.ipSettings(ipSettings));
    }

    public final TlsSettings tlsSettings() {
        return this.httpSettings.tlsSettings();
    }

    public WsSettings tlsSettings(TlsSettings tlsSettings) {
        return this.httpSettings(this.httpSettings.tlsSettings(tlsSettings));
    }

    public final TcpSettings tcpSettings() {
        return this.httpSettings.tcpSettings();
    }

    public WsSettings tcpSettings(TcpSettings tcpSettings) {
        return this.httpSettings(this.httpSettings.tcpSettings(tcpSettings));
    }

    public WsSettings engineSettings(WsEngineSettings engineSettings) {
        return this.copy(engineSettings.maxFrameSize(), engineSettings.maxMessageSize(), engineSettings.serverCompressionLevel(), engineSettings.clientCompressionLevel(), engineSettings.serverNoContextTakeover(), engineSettings.clientNoContextTakeover(), engineSettings.serverMaxWindowBits(), engineSettings.clientMaxWindowBits(), engineSettings.autoClose());
    }

    public WsSettings maxFrameSize(int maxFrameSize) {
        return (WsSettings)super.maxFrameSize(maxFrameSize);
    }

    public WsSettings maxMessageSize(int maxMessageSize) {
        return (WsSettings)super.maxMessageSize(maxMessageSize);
    }

    public WsSettings serverCompressionLevel(int serverCompressionLevel) {
        return (WsSettings)super.serverCompressionLevel(serverCompressionLevel);
    }

    public WsSettings clientCompressionLevel(int clientCompressionLevel) {
        return (WsSettings)super.clientCompressionLevel(clientCompressionLevel);
    }

    public WsSettings compressionLevel(int serverCompressionLevel, int clientCompressionLevel) {
        return (WsSettings)super.compressionLevel(serverCompressionLevel, clientCompressionLevel);
    }

    public WsSettings serverNoContextTakeover(boolean serverNoContextTakeover) {
        return (WsSettings)super.serverNoContextTakeover(serverNoContextTakeover);
    }

    public WsSettings clientNoContextTakeover(boolean clientNoContextTakeover) {
        return (WsSettings)super.clientNoContextTakeover(clientNoContextTakeover);
    }

    public WsSettings serverMaxWindowBits(int serverMaxWindowBits) {
        return (WsSettings)super.serverMaxWindowBits(serverMaxWindowBits);
    }

    public WsSettings clientMaxWindowBits(int clientMaxWindowBits) {
        return (WsSettings)super.clientMaxWindowBits(clientMaxWindowBits);
    }

    public WsSettings autoClose(boolean autoClose) {
        return (WsSettings)super.autoClose(autoClose);
    }

    public Value toValue() {
        return WsSettings.form().mold((Object)this).toValue();
    }

    protected WsSettings copy(HttpSettings httpSettings, int maxFrameSize, int maxMessageSize, int serverCompressionLevel, int clientCompressionLevel, boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits, boolean autoClose) {
        return new WsSettings(httpSettings, maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits, autoClose);
    }

    protected WsSettings copy(int maxFrameSize, int maxMessageSize, int serverCompressionLevel, int clientCompressionLevel, boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits, boolean autoClose) {
        return this.copy(this.httpSettings, maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits, autoClose);
    }

    public boolean canEqual(Object other) {
        return other instanceof WsSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsSettings) {
            WsSettings that = (WsSettings)((Object)other);
            return that.canEqual((Object)this) && this.httpSettings.equals((Object)that.httpSettings) && this.maxFrameSize == that.maxFrameSize && this.maxMessageSize == that.maxMessageSize && this.serverCompressionLevel == that.serverCompressionLevel && this.clientCompressionLevel == that.clientCompressionLevel && this.serverNoContextTakeover == that.serverNoContextTakeover && this.clientNoContextTakeover == that.clientNoContextTakeover && this.serverMaxWindowBits == that.serverMaxWindowBits && this.clientMaxWindowBits == that.clientMaxWindowBits && this.autoClose == that.autoClose;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.httpSettings.hashCode()), (int)this.maxFrameSize), (int)this.maxMessageSize), (int)this.serverCompressionLevel), (int)this.clientCompressionLevel), (int)Murmur3.hash((boolean)this.serverNoContextTakeover)), (int)Murmur3.hash((boolean)this.clientNoContextTakeover)), (int)this.serverMaxWindowBits), (int)this.clientMaxWindowBits), (int)Murmur3.hash((boolean)this.autoClose)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("WsSettings").write(46).write("standard").write(40).write(41).write(46).write("httpSettings").write(40).debug((Object)this.httpSettings).write(41).write(46).write("maxFrameSize").write(40).debug((Object)this.maxFrameSize).write(41).write(46).write("maxMessageSize").write(40).debug((Object)this.maxMessageSize).write(41).write(46).write("serverCompressionLevel").write(40).debug((Object)this.serverCompressionLevel).write(41).write(46).write("clientCompressionLevel").write(40).debug((Object)this.clientCompressionLevel).write(41).write(46).write("serverNoContextTakeover").write(40).debug((Object)this.serverNoContextTakeover).write(41).write(46).write("clientNoContextTakeover").write(40).debug((Object)this.clientNoContextTakeover).write(41).write(46).write("serverMaxWindowBits").write(40).debug((Object)this.serverMaxWindowBits).write(41).write(46).write("clientMaxWindowBits").write(40).debug((Object)this.clientMaxWindowBits).write(41).write(46).write("autoClose").write(40).debug((Object)this.autoClose).write(41);
        return output;
    }

    public static WsSettings standard() {
        if (standard == null) {
            WsEngineSettings engineSettings = WsEngineSettings.standard();
            standard = new WsSettings(HttpSettings.standard(), engineSettings.maxFrameSize(), engineSettings.maxMessageSize(), engineSettings.serverCompressionLevel(), engineSettings.clientCompressionLevel(), engineSettings.serverNoContextTakeover(), engineSettings.clientNoContextTakeover(), engineSettings.serverMaxWindowBits(), engineSettings.clientMaxWindowBits(), engineSettings.autoClose());
        }
        return standard;
    }

    public static WsSettings noCompression() {
        return WsSettings.standard().engineSettings(WsEngineSettings.noCompression());
    }

    public static WsSettings defaultCompression() {
        return WsSettings.standard().engineSettings(WsEngineSettings.defaultCompression());
    }

    public static WsSettings fastestCompression() {
        return WsSettings.standard().engineSettings(WsEngineSettings.fastestCompression());
    }

    public static WsSettings bestCompression() {
        return WsSettings.standard().engineSettings(WsEngineSettings.bestCompression());
    }

    public static WsSettings create(HttpSettings httpSettings) {
        return WsSettings.standard().httpSettings(httpSettings);
    }

    public static WsSettings create(IpSettings ipSettings) {
        return WsSettings.standard().ipSettings(ipSettings);
    }

    public static WsSettings from(WsEngineSettings engineSettings) {
        if (engineSettings instanceof WsSettings) {
            return (WsSettings)engineSettings;
        }
        return WsSettings.standard().engineSettings(engineSettings);
    }

    @Kind
    public static Form<WsSettings> form() {
        if (form == null) {
            form = new WsSettingsForm();
        }
        return form;
    }
}

