/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.net.InetSocketAddress;
import swim.io.IpModem;
import swim.io.IpService;
import swim.io.IpServiceRef;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.IpSocketRef;

public interface IpInterface {
    public IpSettings ipSettings();

    public IpServiceRef bindTcp(InetSocketAddress var1, IpService var2, IpSettings var3);

    default public IpServiceRef bindTcp(InetSocketAddress localAddress, IpService service) {
        return this.bindTcp(localAddress, service, this.ipSettings());
    }

    default public IpServiceRef bindTcp(String address, int port, IpService service, IpSettings ipSettings) {
        return this.bindTcp(new InetSocketAddress(address, port), service, ipSettings);
    }

    default public IpServiceRef bindTcp(String address, int port, IpService service) {
        return this.bindTcp(new InetSocketAddress(address, port), service, this.ipSettings());
    }

    public IpServiceRef bindTls(InetSocketAddress var1, IpService var2, IpSettings var3);

    default public IpServiceRef bindTls(InetSocketAddress localAddress, IpService service) {
        return this.bindTls(localAddress, service, this.ipSettings());
    }

    default public IpServiceRef bindTls(String address, int port, IpService service, IpSettings ipSettings) {
        return this.bindTls(new InetSocketAddress(address, port), service, ipSettings);
    }

    default public IpServiceRef bindTls(String address, int port, IpService service) {
        return this.bindTls(new InetSocketAddress(address, port), service, this.ipSettings());
    }

    public IpSocketRef connectTcp(InetSocketAddress var1, IpSocket var2, IpSettings var3);

    default public IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpSocket socket) {
        return this.connectTcp(remoteAddress, socket, this.ipSettings());
    }

    default public IpSocketRef connectTcp(String address, int port, IpSocket socket, IpSettings ipSettings) {
        return this.connectTcp(new InetSocketAddress(address, port), socket, ipSettings);
    }

    default public IpSocketRef connectTcp(String address, int port, IpSocket socket) {
        return this.connectTcp(new InetSocketAddress(address, port), socket, this.ipSettings());
    }

    default public <I, O> IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpModem<I, O> modem, IpSettings ipSettings) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTcp(remoteAddress, socket, ipSettings);
    }

    default public <I, O> IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpModem<I, O> modem) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTcp(remoteAddress, socket, this.ipSettings());
    }

    default public <I, O> IpSocketRef connectTcp(String address, int port, IpModem<I, O> modem, IpSettings ipSettings) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTcp(new InetSocketAddress(address, port), socket, ipSettings);
    }

    default public <I, O> IpSocketRef connectTcp(String address, int port, IpModem<I, O> modem) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTcp(new InetSocketAddress(address, port), socket, this.ipSettings());
    }

    public IpSocketRef connectTls(InetSocketAddress var1, IpSocket var2, IpSettings var3);

    default public IpSocketRef connectTls(InetSocketAddress remoteAddress, IpSocket socket) {
        return this.connectTls(remoteAddress, socket, this.ipSettings());
    }

    default public IpSocketRef connectTls(String address, int port, IpSocket socket, IpSettings ipSettings) {
        return this.connectTls(new InetSocketAddress(address, port), socket, ipSettings);
    }

    default public IpSocketRef connectTls(String address, int port, IpSocket socket) {
        return this.connectTls(new InetSocketAddress(address, port), socket, this.ipSettings());
    }

    default public <I, O> IpSocketRef connectTls(InetSocketAddress remoteAddress, IpModem<I, O> modem, IpSettings ipSettings) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTls(remoteAddress, socket, ipSettings);
    }

    default public <I, O> IpSocketRef connectTls(InetSocketAddress remoteAddress, IpModem<I, O> modem) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTls(remoteAddress, socket, this.ipSettings());
    }

    default public <I, O> IpSocketRef connectTls(String address, int port, IpModem<I, O> modem, IpSettings ipSettings) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTls(new InetSocketAddress(address, port), socket, ipSettings);
    }

    default public <I, O> IpSocketRef connectTls(String address, int port, IpModem<I, O> modem) {
        IpSocketModem<I, O> socket = new IpSocketModem<I, O>(modem);
        return this.connectTls(new InetSocketAddress(address, port), socket, this.ipSettings());
    }
}

