/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.TransportSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class TransportSettings
implements Debug {
    protected final int backlog;
    protected final long idleInterval;
    protected final long idleTimeout;
    private static int hashSeed;
    private static TransportSettings standard;
    private static Form<TransportSettings> form;

    public TransportSettings(int backlog, long idleInterval, long idleTimeout) {
        this.backlog = backlog;
        this.idleInterval = idleInterval;
        this.idleTimeout = idleTimeout;
    }

    public final int backlog() {
        return this.backlog;
    }

    public TransportSettings backlog(int backlog) {
        return this.copy(backlog, this.idleInterval, this.idleTimeout);
    }

    public final long idleInterval() {
        return this.idleInterval;
    }

    public TransportSettings idleInterval(long idleInterval) {
        return this.copy(this.backlog, idleInterval, this.idleTimeout);
    }

    public final long idleTimeout() {
        return this.idleTimeout;
    }

    public TransportSettings idleTimeout(long idleTimeout) {
        return this.copy(this.backlog, this.idleInterval, idleTimeout);
    }

    protected TransportSettings copy(int backlog, long idleInterval, long idleTimeout) {
        return new TransportSettings(backlog, idleInterval, idleTimeout);
    }

    public Value toValue() {
        return TransportSettings.form().mold((Object)this).toValue();
    }

    public boolean canEqual(Object other) {
        return other instanceof TransportSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TransportSettings) {
            TransportSettings that = (TransportSettings)other;
            return that.canEqual(this) && this.backlog == that.backlog && this.idleInterval == that.idleInterval && this.idleTimeout == that.idleTimeout;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TransportSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.backlog), (int)Murmur3.hash((long)this.idleInterval)), (int)Murmur3.hash((long)this.idleTimeout)));
    }

    public void debug(Output<?> output) {
        output = output.write("TransportSettings").write(46).write("standard").write(40).write(41).write(46).write("backlog").write(40).debug((Object)this.backlog).write(41).write(46).write("idleInterval").write(40).debug((Object)this.idleInterval).write(41).write(46).write("idleTimeout").write(40).debug((Object)this.idleTimeout).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static TransportSettings standard() {
        if (standard == null) {
            long idleTimeout;
            long idleInterval;
            int backlog;
            try {
                backlog = Integer.parseInt(System.getProperty("swim.transport.backlog"));
            }
            catch (NumberFormatException error) {
                backlog = 0;
            }
            try {
                idleInterval = Long.parseLong(System.getProperty("swim.transport.idle.interval"));
            }
            catch (NumberFormatException error) {
                idleInterval = 30000L;
            }
            try {
                idleTimeout = Long.parseLong(System.getProperty("swim.transport.idle.timeout"));
            }
            catch (NumberFormatException error) {
                idleTimeout = 90000L;
            }
            standard = new TransportSettings(backlog, idleInterval, idleTimeout);
        }
        return standard;
    }

    @Kind
    public static Form<TransportSettings> form() {
        if (form == null) {
            form = new TransportSettingsForm();
        }
        return form;
    }
}

