/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.codec.Debug;
import swim.codec.Output;

public enum FlowModifier implements Debug
{
    RESELECT(0),
    DISABLE_READ(1),
    DISABLE_WRITE(2),
    DISABLE_READ_WRITE(3),
    ENABLE_READ(4),
    DISABLE_WRITE_ENABLE_READ(6),
    ENABLE_WRITE(8),
    DISABLE_READ_ENABLE_WRITE(9),
    ENABLE_READ_WRITE(12);

    private final int flags;

    private FlowModifier(int flags) {
        this.flags = flags;
    }

    private static FlowModifier fromFlags(int flags) {
        if ((flags ^ 5) == 0) {
            flags &= 0xFFFFFFFE;
        }
        if ((flags ^ 0xA) == 0) {
            flags &= 0xFFFFFFFD;
        }
        switch (flags) {
            case 0: {
                return RESELECT;
            }
            case 1: {
                return DISABLE_READ;
            }
            case 2: {
                return DISABLE_WRITE;
            }
            case 3: {
                return DISABLE_READ_WRITE;
            }
            case 4: {
                return ENABLE_READ;
            }
            case 6: {
                return DISABLE_WRITE_ENABLE_READ;
            }
            case 8: {
                return ENABLE_WRITE;
            }
            case 9: {
                return DISABLE_READ_ENABLE_WRITE;
            }
            case 12: {
                return ENABLE_READ_WRITE;
            }
        }
        throw new IllegalArgumentException("0x" + Integer.toHexString(flags));
    }

    public boolean isReadDisabled() {
        return (this.flags & 1) != 0;
    }

    public boolean isWriteDisabled() {
        return (this.flags & 2) != 0;
    }

    public boolean isReadEnabled() {
        return (this.flags & 4) != 0;
    }

    public boolean isWriteEnabled() {
        return (this.flags & 8) != 0;
    }

    public FlowModifier or(FlowModifier that) {
        return FlowModifier.fromFlags(this.flags | that.flags);
    }

    public FlowModifier xor(FlowModifier that) {
        return FlowModifier.fromFlags(this.flags ^ that.flags);
    }

    public FlowModifier and(FlowModifier that) {
        return FlowModifier.fromFlags(this.flags & that.flags);
    }

    public FlowModifier not() {
        return FlowModifier.fromFlags(~this.flags & 0xF);
    }

    public void debug(Output<?> output) {
        output = output.write("FlowModifier").write(46).write(this.name());
    }
}

