/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.net.Socket;
import java.net.SocketException;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.IpSettingsForm;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class IpSettings
implements Debug {
    private static int hashSeed;
    private static IpSettings standard;
    private static Form<IpSettings> form;
    protected final TcpSettings tcpSettings;
    protected final TlsSettings tlsSettings;

    public IpSettings(TcpSettings tcpSettings, TlsSettings tlsSettings) {
        this.tcpSettings = tcpSettings;
        this.tlsSettings = tlsSettings;
    }

    public static IpSettings standard() {
        if (standard == null) {
            standard = new IpSettings(TcpSettings.standard(), TlsSettings.standard());
        }
        return standard;
    }

    public static IpSettings from(TcpSettings tcpSettings) {
        return new IpSettings(tcpSettings, TlsSettings.standard());
    }

    public static IpSettings from(TlsSettings tlsSettings) {
        return new IpSettings(TcpSettings.standard(), tlsSettings);
    }

    @Kind
    public static Form<IpSettings> form() {
        if (form == null) {
            form = new IpSettingsForm();
        }
        return form;
    }

    public TcpSettings tcpSettings() {
        return this.tcpSettings;
    }

    public IpSettings tcpSettings(TcpSettings tcpSettings) {
        return this.copy(tcpSettings, this.tlsSettings);
    }

    public TlsSettings tlsSettings() {
        return this.tlsSettings;
    }

    public IpSettings tlsSettings(TlsSettings tlsSettings) {
        return this.copy(this.tcpSettings, tlsSettings);
    }

    protected IpSettings copy(TcpSettings tcpSettings, TlsSettings tlsSettings) {
        return new IpSettings(tcpSettings, tlsSettings);
    }

    public void configure(Socket socket) throws SocketException {
        this.tcpSettings.configure(socket);
    }

    public Value toValue() {
        return IpSettings.form().mold((Object)this).toValue();
    }

    public boolean canEqual(Object other) {
        return other instanceof IpSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof IpSettings) {
            IpSettings that = (IpSettings)other;
            return that.canEqual(this) && this.tcpSettings.equals(that.tcpSettings) && this.tlsSettings.equals(that.tlsSettings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(IpSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.tcpSettings.hashCode()), (int)this.tlsSettings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("IpSettings").write(46).write("standard").write(40).write(41).write(46).write("tcpSettings").write(40).debug((Object)this.tcpSettings).write(41).write(46).write("tlsSettings").write(40).debug((Object)this.tlsSettings).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

