/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.MainStage;
import swim.concurrent.Stage;
import swim.io.FlowControl;
import swim.io.StationException;
import swim.io.StationThread;
import swim.io.StationTransport;
import swim.io.Transport;
import swim.io.TransportRef;
import swim.io.TransportSettings;

public class Station {
    static final int STARTED = 1;
    static final int STOPPED = 2;
    static final AtomicIntegerFieldUpdater<Station> STATUS = AtomicIntegerFieldUpdater.newUpdater(Station.class, "status");
    protected final Stage stage;
    final CountDownLatch startLatch;
    final CountDownLatch stopLatch;
    final StationThread thread;
    protected TransportSettings transportSettings;
    volatile int status;

    public Station(Stage stage, TransportSettings transportSettings) {
        this.stage = stage;
        this.transportSettings = transportSettings != null ? transportSettings : TransportSettings.standard();
        this.startLatch = new CountDownLatch(1);
        this.stopLatch = new CountDownLatch(1);
        this.thread = new StationThread(this);
    }

    public Station(Stage stage) {
        this(stage, null);
    }

    public final Stage stage() {
        return this.stage;
    }

    public final TransportSettings transportSettings() {
        return this.transportSettings;
    }

    public Station transportSettings(TransportSettings transportSettings) {
        this.transportSettings = transportSettings;
        return this;
    }

    public void start() {
        block6: {
            int oldStatus;
            while (((oldStatus = STATUS.get(this)) & 2) == 0) {
                if ((oldStatus & 1) == 0) {
                    int newStatus = oldStatus | 1;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    this.willStart();
                    this.thread.start();
                }
                break block6;
            }
            throw new StationException("Can't restart stopped station");
        }
        boolean interrupted = false;
        while (this.startLatch.getCount() != 0L) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException error) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        int oldStatus;
        boolean interrupted = false;
        while (((oldStatus = STATUS.get(this)) & 2) == 0) {
            int newStatus = oldStatus | 2;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            while (this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join(100L);
                }
                catch (InterruptedException error) {
                    interrupted = true;
                }
            }
        }
        while (this.stopLatch.getCount() != 0L) {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (this.stage instanceof MainStage) {
            ((MainStage)this.stage).stop();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public TransportRef transport(Transport transport, FlowControl flowControl) {
        this.start();
        StationTransport context = new StationTransport(this, transport, flowControl);
        transport.setTransportContext(context);
        this.reselect(context);
        return context;
    }

    void reselect(StationTransport context) {
        this.thread.reselect(context);
    }

    protected void willStart() {
    }

    protected void didStart() {
    }

    protected void willStop() {
    }

    protected void didStop() {
    }

    protected void didFail(Throwable error) {
        error.printStackTrace();
    }

    protected void transportDidAccept(Transport transport) {
    }

    protected void transportDidConnect(Transport transport) {
    }

    protected void transportDidTimeout(Transport transport) {
    }

    protected void transportDidClose(Transport transport) {
    }

    protected void transportDidFail(Transport transport, Throwable error) {
        if (!(error instanceof IOException)) {
            error.printStackTrace();
        }
    }
}

