/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.Conts;
import swim.concurrent.TaskFunction;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.Station;
import swim.io.StationReader;
import swim.io.StationWriter;
import swim.io.Transport;
import swim.io.TransportContext;
import swim.io.TransportRef;
import swim.io.TransportSettings;

final class StationTransport
implements TransportContext,
TransportRef {
    static final AtomicReferenceFieldUpdater<StationTransport, FlowControl> FLOW_CONTROL = AtomicReferenceFieldUpdater.newUpdater(StationTransport.class, FlowControl.class, "flowControl");
    final Station station;
    final Transport transport;
    volatile FlowControl flowControl;
    StationReader reader;
    StationWriter writer;
    SelectionKey selectionKey;
    volatile long lastSelectTime;

    StationTransport(Station station, Transport transport, FlowControl flowControl) {
        this.station = station;
        this.transport = transport;
        this.flowControl = flowControl;
    }

    void reselect() {
        this.station.reselect(this);
    }

    long idleTimeout() {
        return this.transport.idleTimeout();
    }

    @Override
    public TransportSettings transportSettings() {
        return this.station.transportSettings;
    }

    @Override
    public FlowControl flowControl() {
        return FLOW_CONTROL.get(this);
    }

    @Override
    public void flowControl(FlowControl newFlow) {
        FlowControl oldFlow = FLOW_CONTROL.getAndSet(this, newFlow);
        if (!oldFlow.equals((Object)newFlow)) {
            this.reselect();
        }
    }

    @Override
    public FlowControl flowControl(FlowModifier flowModifier) {
        FlowControl newFlow;
        FlowControl oldFlow;
        while (!(oldFlow = FLOW_CONTROL.get(this)).equals((Object)(newFlow = oldFlow.modify(flowModifier)))) {
            if (!FLOW_CONTROL.compareAndSet(this, oldFlow, newFlow)) continue;
            this.reselect();
            return newFlow;
        }
        return newFlow;
    }

    @Override
    public void close() {
        try {
            this.transport.channel().close();
        }
        catch (IOException error) {
            this.station.transportDidFail(this.transport, error);
        }
        this.didClose();
    }

    void doAccept() {
        try {
            this.transport.doAccept();
            this.station.transportDidAccept(this.transport);
        }
        catch (ClosedChannelException error) {
            this.didClose();
        }
        catch (IOException error) {
            this.didFail(error);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    void doConnect() {
        FlowControl newFlowControl;
        FlowControl oldFlowControl;
        while ((oldFlowControl = FLOW_CONTROL.get(this)).isConnectEnabled() && !FLOW_CONTROL.compareAndSet(this, oldFlowControl, newFlowControl = oldFlowControl.connectDisabled())) {
        }
        try {
            this.transport.doConnect();
            this.station.transportDidConnect(this.transport);
        }
        catch (ClosedChannelException error) {
            this.didClose();
        }
        catch (IOException error) {
            this.didFail(error);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    void cueRead() {
        StationReader reader = this.reader;
        if (reader == null) {
            reader = new StationReader(this);
            this.station.stage.task((TaskFunction)reader);
            this.reader = reader;
        }
        reader.cue();
    }

    boolean doRead() {
        ByteBuffer readBuffer = this.transport.readBuffer();
        ReadableByteChannel channel = (ReadableByteChannel)((Object)this.transport.channel());
        boolean yield = false;
        while (FLOW_CONTROL.get(this).isReadEnabled()) {
            int count;
            try {
                count = channel.read(readBuffer);
            }
            catch (ClosedChannelException error) {
                this.didClose();
                break;
            }
            catch (IOException error) {
                this.didFail(error);
                break;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
            if (count < 0) {
                this.close();
                break;
            }
            if (readBuffer.position() > 0) {
                ((Buffer)readBuffer).flip();
                try {
                    this.transport.doRead();
                }
                catch (Throwable error) {
                    if (Conts.isNonFatal((Throwable)error)) {
                        this.didFail(error);
                        break;
                    }
                    throw error;
                }
                if (readBuffer.hasRemaining()) {
                    int currentPos = readBuffer.position();
                    readBuffer.compact();
                    if (count != 0 || currentPos != 0) continue;
                    yield = true;
                    break;
                }
                ((Buffer)readBuffer).clear();
                continue;
            }
            this.reselect();
            break;
        }
        return yield;
    }

    void cueWrite() {
        StationWriter writer = this.writer;
        if (writer == null) {
            writer = new StationWriter(this);
            this.station.stage.task((TaskFunction)writer);
            this.writer = writer;
        }
        writer.cue();
    }

    void doWrite() {
        block15: {
            block16: {
                ByteBuffer writeBuffer = this.transport.writeBuffer();
                WritableByteChannel channel = (WritableByteChannel)((Object)this.transport.channel());
                while (true) {
                    if (writeBuffer.hasRemaining()) {
                        int count;
                        try {
                            count = channel.write(writeBuffer);
                        }
                        catch (ClosedChannelException error) {
                            this.didClose();
                            break block15;
                        }
                        catch (IOException error) {
                            this.didFail(error);
                            break block15;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                break block15;
                            }
                            throw error;
                        }
                        if (count > 0) {
                            if (!writeBuffer.hasRemaining()) {
                                try {
                                    this.transport.didWrite();
                                }
                                catch (Throwable error) {
                                    if (Conts.isNonFatal((Throwable)error)) {
                                        this.didFail(error);
                                        return;
                                    }
                                    throw error;
                                }
                            }
                            this.reselect();
                            break block15;
                        }
                        this.reselect();
                        break block15;
                    }
                    if (!FLOW_CONTROL.get(this).isWriteEnabled()) break block16;
                    ((Buffer)writeBuffer).clear();
                    try {
                        this.transport.doWrite();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            return;
                        }
                        throw error;
                    }
                    ((Buffer)writeBuffer).flip();
                    if (!writeBuffer.hasRemaining()) break;
                }
                this.reselect();
                break block15;
            }
            this.reselect();
        }
    }

    void didTimeout() {
        this.transport.didTimeout();
        this.station.transportDidTimeout(this.transport);
    }

    void didClose() {
        StationWriter writer;
        StationReader reader = this.reader;
        if (reader != null) {
            reader.cancel();
        }
        if ((writer = this.writer) != null) {
            writer.cancel();
        }
        this.transport.didClose();
        this.station.transportDidClose(this.transport);
    }

    void didFail(Throwable error) {
        this.transport.didFail(error);
        this.station.transportDidFail(this.transport, error);
    }
}

