/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpService;
import swim.io.IpServiceContext;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.Station;
import swim.io.TcpSocket;
import swim.io.Transport;
import swim.io.TransportContext;

class TcpService
implements Transport,
IpServiceContext {
    final Station station;
    final InetSocketAddress localAddress;
    final ServerSocketChannel serverChannel;
    final IpService service;
    final IpSettings ipSettings;
    TransportContext context;

    TcpService(Station station, InetSocketAddress localAddress, ServerSocketChannel serverChannel, IpService service, IpSettings ipSettings) {
        this.station = station;
        this.localAddress = localAddress;
        this.serverChannel = serverChannel;
        this.service = service;
        this.ipSettings = ipSettings;
    }

    @Override
    public TransportContext transportContext() {
        return this.context;
    }

    @Override
    public void setTransportContext(TransportContext context) {
        this.context = context;
    }

    @Override
    public ServerSocketChannel channel() {
        return this.serverChannel;
    }

    @Override
    public ByteBuffer readBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer writeBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long idleTimeout() {
        return 0L;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public IpSettings ipSettings() {
        return this.ipSettings;
    }

    @Override
    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    @Override
    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    @Override
    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public void unbind() {
        this.context.close();
    }

    @Override
    public void doAccept() throws IOException {
        SocketChannel channel;
        try {
            channel = this.serverChannel.accept();
        }
        catch (ClosedChannelException error) {
            return;
        }
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        this.ipSettings.configure(channel.socket());
        IpSocket socket = this.service.createSocket();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
        TcpSocket transport = new TcpSocket(this.localAddress, remoteAddress, channel, this.ipSettings, false);
        transport.become(socket);
        this.station.transport(transport, FlowControl.WAIT);
        this.service.didAccept(socket);
        transport.didConnect();
    }

    @Override
    public void doConnect() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void didWrite() {
        throw new UnsupportedOperationException();
    }

    void didBind() {
        this.service.didBind();
    }

    void didAccept(IpSocket socket) {
        this.service.didAccept(socket);
    }

    void didUnbind() {
        this.service.didUnbind();
    }

    @Override
    public void didTimeout() {
    }

    @Override
    public void didClose() {
        this.didUnbind();
    }

    @Override
    public void didFail(Throwable error) {
        this.service.didFail(error);
    }
}

