/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.codec.Binary;
import swim.codec.InputBuffer;
import swim.codec.OutputBuffer;
import swim.concurrent.Conts;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketContext;
import swim.io.TcpSettings;
import swim.io.Transport;
import swim.io.TransportContext;

class TcpSocket
implements Transport,
IpSocketContext {
    static final int CLIENT = 1;
    static final int SERVER = 2;
    static final int CONNECTING = 4;
    static final int CONNECTED = 8;
    static final AtomicIntegerFieldUpdater<TcpSocket> STATUS = AtomicIntegerFieldUpdater.newUpdater(TcpSocket.class, "status");
    final InetSocketAddress localAddress;
    final InetSocketAddress remoteAddress;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    final InputBuffer inputBuffer;
    final OutputBuffer<?> outputBuffer;
    final SocketChannel channel;
    final IpSettings ipSettings;
    TransportContext context;
    volatile IpSocket socket;
    volatile int status;

    TcpSocket(InetSocketAddress localAddress, InetSocketAddress remoteAddress, SocketChannel channel, IpSettings ipSettings, boolean isClient) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.channel = channel;
        this.ipSettings = ipSettings;
        this.status = isClient ? 1 : 2;
        TcpSettings tcpSettings = ipSettings.tcpSettings();
        this.readBuffer = ByteBuffer.allocate(tcpSettings.readBufferSize());
        this.writeBuffer = ByteBuffer.allocate(tcpSettings.writeBufferSize());
        ((Buffer)this.writeBuffer).position(this.writeBuffer.capacity());
        this.inputBuffer = Binary.inputBuffer((ByteBuffer)this.readBuffer);
        this.outputBuffer = Binary.outputBuffer((ByteBuffer)this.writeBuffer);
    }

    @Override
    public TransportContext transportContext() {
        return this.context;
    }

    @Override
    public void setTransportContext(TransportContext context) {
        this.context = context;
    }

    @Override
    public SocketChannel channel() {
        return this.channel;
    }

    @Override
    public ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    @Override
    public ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    public long idleTimeout() {
        return this.socket.idleTimeout();
    }

    @Override
    public IpSettings ipSettings() {
        return this.ipSettings;
    }

    @Override
    public InputBuffer inputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public OutputBuffer<?> outputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public boolean isConnected() {
        return (STATUS.get(this) & 8) != 0;
    }

    @Override
    public boolean isClient() {
        return (STATUS.get(this) & 1) != 0;
    }

    @Override
    public boolean isServer() {
        return (STATUS.get(this) & 2) != 0;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public String securityProtocol() {
        return null;
    }

    @Override
    public String cipherSuite() {
        return null;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public Principal localPrincipal() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificates() {
        return Collections.emptyList();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public Principal remotePrincipal() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificates() {
        return Collections.emptyList();
    }

    @Override
    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    @Override
    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    @Override
    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public void become(IpSocket newSocket) {
        IpSocket oldSocket = this.socket;
        if (oldSocket != null) {
            oldSocket.willBecome(newSocket);
        }
        int status = STATUS.get(this);
        newSocket.setIpSocketContext(this);
        this.socket = newSocket;
        if ((status & 8) != 0) {
            newSocket.didConnect();
        } else if ((status & 4) != 0) {
            newSocket.willConnect();
        }
        if (oldSocket != null) {
            oldSocket.didBecome(newSocket);
        }
    }

    @Override
    public void close() {
        this.context.close();
    }

    @Override
    public void doAccept() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doConnect() throws IOException {
        try {
            this.channel.finishConnect();
            this.didConnect();
        }
        catch (ConnectException error) {
            this.didClose();
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    @Override
    public void doRead() {
        this.socket.doRead();
    }

    @Override
    public void doWrite() {
        this.socket.doWrite();
    }

    @Override
    public void didWrite() {
        this.socket.didWrite();
    }

    void willConnect() {
        block1: {
            int newStatus;
            int oldStatus;
            do {
                oldStatus = STATUS.get(this);
                if ((this.status & 4) != 0) break block1;
            } while (!STATUS.compareAndSet(this, oldStatus, newStatus = oldStatus | 4));
            this.socket.willConnect();
        }
    }

    void didConnect() {
        int oldStatus;
        while (((oldStatus = STATUS.get(this)) & 0xC) != 8) {
            int newStatus = oldStatus & 0xFFFFFFFB | 8;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.socket.didConnect();
            break;
        }
    }

    @Override
    public void didClose() {
        block1: {
            int newStatus;
            int oldStatus;
            do {
                oldStatus = STATUS.get(this);
                if ((this.status & 0xC) == 0) break block1;
            } while (!STATUS.compareAndSet(this, oldStatus, newStatus = oldStatus & 0xFFFFFFF3));
            this.socket.didDisconnect();
        }
    }

    @Override
    public void didTimeout() {
        this.socket.didTimeout();
    }

    @Override
    public void didFail(Throwable error) {
        if (!(error instanceof IOException)) {
            this.socket.didFail(error);
        }
        this.close();
    }
}

