/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.io.ClientAuth;
import swim.io.TlsSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class TlsSettings
implements Debug {
    private static int hashSeed;
    private static TlsSettings standard;
    private static Form<TlsSettings> form;
    protected final SSLContext sslContext;
    protected final ClientAuth clientAuth;
    protected final Collection<String> cipherSuites;
    protected final Collection<String> protocols;

    public TlsSettings(SSLContext sslContext, ClientAuth clientAuth, Collection<String> cipherSuites, Collection<String> protocols) {
        this.sslContext = sslContext;
        this.clientAuth = clientAuth;
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
    }

    public static TlsSettings create(ClientAuth clientAuth, Collection<String> cipherSuites, Collection<String> protocols) {
        try {
            String tlsProtocol = System.getProperty("swim.tls.protocol", "TLS");
            String tlsProvider = System.getProperty("swim.tls.provider");
            String tlsRandom = System.getProperty("swim.tls.random");
            SecureRandom random = tlsRandom != null ? SecureRandom.getInstance(tlsRandom) : new SecureRandom();
            SSLContext sslContext = tlsProvider != null ? SSLContext.getInstance(tlsProtocol, tlsProvider) : SSLContext.getInstance(tlsProtocol);
            KeyManager[] keyManagers = TlsSettings.loadKeyManagers();
            TrustManager[] trustManagers = TlsSettings.loadTrustManagers();
            sslContext.init(keyManagers, trustManagers, random);
            return new TlsSettings(sslContext, clientAuth, cipherSuites, protocols);
        }
        catch (GeneralSecurityException cause) {
            return null;
        }
    }

    public static TlsSettings standard() {
        if (standard == null) {
            FingerTrieSeq protocols;
            FingerTrieSeq cipherSuites;
            ClientAuth clientAuth;
            try {
                clientAuth = ClientAuth.from(System.getProperty("swim.tls.client.auth"));
            }
            catch (IllegalArgumentException swallow) {
                clientAuth = ClientAuth.NONE;
            }
            try {
                cipherSuites = FingerTrieSeq.of((Object[])System.getProperty("swim.tls.ciphersuites").split(","));
            }
            catch (NullPointerException cause) {
                cipherSuites = null;
            }
            try {
                protocols = FingerTrieSeq.of((Object[])System.getProperty("swim.tls.protocols").split(","));
            }
            catch (NullPointerException cause) {
                protocols = null;
            }
            standard = TlsSettings.create(clientAuth, (Collection<String>)cipherSuites, (Collection<String>)protocols);
        }
        return standard;
    }

    @Kind
    public static Form<TlsSettings> form() {
        if (form == null) {
            form = new TlsSettingsForm();
        }
        return form;
    }

    static KeyManager[] loadKeyManagers() {
        String path = System.getProperty("swim.tls.keystore.path");
        String resource = System.getProperty("swim.tls.keystore.resource");
        if (path != null || resource != null) {
            String type = System.getProperty("swim.tls.keystore.type", KeyStore.getDefaultType());
            String provider = System.getProperty("swim.tls.keystore.provider");
            String password = System.getProperty("swim.tls.keystore.password");
            char[] passwordChars = password != null ? password.toCharArray() : null;
            InputStream inputStream = null;
            try {
                KeyManagerFactory keyManagerFactory;
                KeyStore keyStore;
                if (provider != null) {
                    keyStore = KeyStore.getInstance(type, provider);
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm(), provider);
                } else {
                    keyStore = KeyStore.getInstance(type);
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
                if (path != null) {
                    inputStream = new FileInputStream(path);
                } else if (resource != null && (inputStream = ClassLoader.getSystemResourceAsStream(resource)) == null) {
                    throw new RuntimeException("Missing swim.tls.keystore.resource: " + resource);
                }
                keyStore.load(inputStream, passwordChars);
                keyManagerFactory.init(keyStore, passwordChars);
                KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                return keyManagerArray;
            }
            catch (IOException | GeneralSecurityException cause) {
                throw new RuntimeException(cause);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException cause) {
                    throw new RuntimeException(cause);
                }
            }
        }
        return null;
    }

    static TrustManager[] loadTrustManagers() {
        String path = System.getProperty("swim.tls.truststore.path");
        String resource = System.getProperty("swim.tls.truststore.resource");
        if (path != null || resource != null) {
            String type = System.getProperty("swim.tls.truststore.type", KeyStore.getDefaultType());
            String provider = System.getProperty("swim.tls.truststore.provider");
            String password = System.getProperty("swim.tls.truststore.password");
            char[] passwordChars = password != null ? password.toCharArray() : null;
            InputStream inputStream = null;
            try {
                TrustManagerFactory trustManagerFactory;
                KeyStore trustStore;
                if (provider != null) {
                    trustStore = KeyStore.getInstance(type, provider);
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), provider);
                } else {
                    trustStore = KeyStore.getInstance(type);
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                }
                if (path != null) {
                    inputStream = new FileInputStream(path);
                } else if (resource != null && (inputStream = ClassLoader.getSystemResourceAsStream(resource)) == null) {
                    throw new RuntimeException("Missing swim.tls.truststore.resource: " + resource);
                }
                trustStore.load(inputStream, passwordChars);
                trustManagerFactory.init(trustStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                return trustManagerArray;
            }
            catch (IOException | GeneralSecurityException cause) {
                throw new RuntimeException(cause);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException cause) {
                    throw new RuntimeException(cause);
                }
            }
        }
        return null;
    }

    public final SSLContext sslContext() {
        return this.sslContext;
    }

    public TlsSettings sslContext(SSLContext sslContext) {
        return this.copy(sslContext, this.clientAuth, this.cipherSuites, this.protocols);
    }

    public final ClientAuth clientAuth() {
        return this.clientAuth;
    }

    public TlsSettings clientAuth(ClientAuth clientAuth) {
        return this.copy(this.sslContext, clientAuth, this.cipherSuites, this.protocols);
    }

    public final Collection<String> cipherSuites() {
        return this.cipherSuites;
    }

    public TlsSettings cipherSuites(Collection<String> cipherSuites) {
        return this.copy(this.sslContext, this.clientAuth, cipherSuites, this.protocols);
    }

    public final Collection<String> protocols() {
        return this.protocols;
    }

    public TlsSettings protocols(Collection<String> protocols) {
        return this.copy(this.sslContext, this.clientAuth, this.cipherSuites, protocols);
    }

    protected TlsSettings copy(SSLContext sslContext, ClientAuth clientAuth, Collection<String> cipherSuites, Collection<String> protocols) {
        return new TlsSettings(sslContext, clientAuth, cipherSuites, protocols);
    }

    public Value toValue() {
        return TlsSettings.form().mold((Object)this).toValue();
    }

    public boolean canEqual(Object other) {
        return other instanceof TlsSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TlsSettings) {
            TlsSettings that = (TlsSettings)other;
            return that.canEqual(this) && (this.sslContext == null ? that.sslContext == null : this.sslContext.equals(that.sslContext)) && this.clientAuth.equals((Object)that.clientAuth) && (this.cipherSuites == null ? that.cipherSuites == null : this.cipherSuites.equals(that.cipherSuites)) && (this.protocols == null ? that.protocols == null : this.protocols.equals(that.protocols));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TlsSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.sslContext)), (int)this.clientAuth.hashCode()), (int)Murmur3.hash(this.cipherSuites)), (int)Murmur3.hash(this.protocols)));
    }

    public void debug(Output<?> output) {
        output = output.write("TlsSettings").write(46).write("standard").write(40).write(41).write(46).write("sslContext").write(40).debug((Object)this.sslContext).write(41).write(46).write("clientAuth").write(40).debug((Object)this.clientAuth).write(41).write(46).write("cipherSuites").write(40).debug(this.cipherSuites).write(41).write(46).write("protocols").write(40).debug(this.protocols).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

