/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import swim.codec.Binary;
import swim.codec.InputBuffer;
import swim.codec.OutputBuffer;
import swim.concurrent.Conts;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketContext;
import swim.io.TcpSettings;
import swim.io.Transport;
import swim.io.TransportContext;

class TlsSocket
implements Transport,
IpSocketContext {
    static final int CLIENT = 1;
    static final int SERVER = 2;
    static final int CONNECTING = 4;
    static final int CONNECTED = 8;
    static final int HANDSHAKING = 16;
    static final int HANDSHAKED = 32;
    static final int OPEN = 64;
    static final int CLOSING_INBOUND = 128;
    static final int CLOSING_OUTBOUND = 256;
    static final AtomicReferenceFieldUpdater<TlsSocket, FlowControl> FLOW_CONTROL = AtomicReferenceFieldUpdater.newUpdater(TlsSocket.class, FlowControl.class, "flowControl");
    static final AtomicIntegerFieldUpdater<TlsSocket> STATUS = AtomicIntegerFieldUpdater.newUpdater(TlsSocket.class, "status");
    final InetSocketAddress localAddress;
    final InetSocketAddress remoteAddress;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    final ByteBuffer inputBuffer;
    final ByteBuffer outputBuffer;
    final InputBuffer reader;
    final OutputBuffer<?> writer;
    final SocketChannel channel;
    final SSLEngine sslEngine;
    final IpSettings ipSettings;
    TransportContext context;
    volatile IpSocket socket;
    volatile FlowControl flowControl;
    volatile int status;

    TlsSocket(InetSocketAddress localAddress, InetSocketAddress remoteAddress, SocketChannel channel, SSLEngine sslEngine, IpSettings ipSettings, boolean isClient) {
        if (sslEngine == null) {
            throw new NullPointerException();
        }
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.channel = channel;
        this.sslEngine = sslEngine;
        this.ipSettings = ipSettings;
        this.flowControl = FlowControl.WAIT;
        this.status = isClient ? 1 : 2;
        SSLSession sslSession = this.sslEngine.getSession();
        TcpSettings tcpSettings = this.ipSettings.tcpSettings();
        int readBufferSize = Math.max(tcpSettings.readBufferSize(), sslSession.getApplicationBufferSize());
        int writeBufferSize = Math.max(tcpSettings.writeBufferSize(), sslSession.getPacketBufferSize());
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
        this.writeBuffer = ByteBuffer.allocate(writeBufferSize);
        ((Buffer)this.writeBuffer).position(this.writeBuffer.capacity());
        this.inputBuffer = ByteBuffer.allocate(readBufferSize);
        this.outputBuffer = ByteBuffer.allocate(writeBufferSize);
        ((Buffer)this.outputBuffer).position(this.outputBuffer.capacity());
        this.reader = Binary.inputBuffer((ByteBuffer)this.inputBuffer);
        this.writer = Binary.outputBuffer((ByteBuffer)this.outputBuffer);
    }

    @Override
    public TransportContext transportContext() {
        return this.context;
    }

    @Override
    public void setTransportContext(TransportContext context) {
        this.context = context;
    }

    @Override
    public SocketChannel channel() {
        return this.channel;
    }

    @Override
    public ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    @Override
    public ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    public long idleTimeout() {
        return this.socket.idleTimeout();
    }

    @Override
    public IpSettings ipSettings() {
        return this.ipSettings;
    }

    @Override
    public InputBuffer inputBuffer() {
        return this.reader;
    }

    @Override
    public OutputBuffer<?> outputBuffer() {
        return this.writer;
    }

    @Override
    public boolean isConnected() {
        return (this.status & 8) != 0;
    }

    @Override
    public boolean isClient() {
        return (this.status & 1) != 0;
    }

    @Override
    public boolean isServer() {
        return (this.status & 2) != 0;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public String securityProtocol() {
        return this.sslEngine.getSession().getProtocol();
    }

    @Override
    public String cipherSuite() {
        return this.sslEngine.getSession().getCipherSuite();
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public Principal localPrincipal() {
        return this.sslEngine.getSession().getLocalPrincipal();
    }

    @Override
    public Collection<Certificate> localCertificates() {
        Certificate[] certificates = this.sslEngine.getSession().getLocalCertificates();
        if (certificates != null) {
            return Arrays.asList(certificates);
        }
        return Collections.emptyList();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public Principal remotePrincipal() {
        try {
            return this.sslEngine.getSession().getPeerPrincipal();
        }
        catch (SSLException error) {
            return null;
        }
    }

    @Override
    public Collection<Certificate> remoteCertificates() {
        try {
            Certificate[] certificates = this.sslEngine.getSession().getPeerCertificates();
            if (certificates != null) {
                return Arrays.asList(certificates);
            }
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    public FlowControl flowControl() {
        return this.flowControl;
    }

    @Override
    public void flowControl(FlowControl flowControl) {
        FLOW_CONTROL.set(this, flowControl);
        if ((this.status & 0x40) != 0) {
            this.context.flowControl(flowControl);
        }
    }

    @Override
    public FlowControl flowControl(FlowModifier flowModifier) {
        FlowControl newFlow;
        FlowControl oldFlow;
        while (!(oldFlow = this.flowControl).equals((Object)(newFlow = oldFlow.modify(flowModifier))) && !FLOW_CONTROL.compareAndSet(this, oldFlow, newFlow)) {
        }
        if ((this.status & 0x40) != 0) {
            return this.context.flowControl(flowModifier);
        }
        return newFlow;
    }

    @Override
    public void become(IpSocket newSocket) {
        IpSocket oldSocket = this.socket;
        if (oldSocket != null) {
            oldSocket.willBecome(newSocket);
        }
        int status = this.status;
        newSocket.setIpSocketContext(this);
        this.socket = newSocket;
        if ((status & 8) != 0) {
            newSocket.didConnect();
        } else if ((status & 4) != 0) {
            newSocket.willConnect();
        }
        if (oldSocket != null) {
            oldSocket.didBecome(newSocket);
        }
    }

    @Override
    public void close() {
        block1: {
            int oldStatus;
            while (((oldStatus = this.status) & 0x40) != 0) {
                int newStatus = oldStatus & 0xFFFFFFBF | 0x100;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                this.sslEngine.closeOutbound();
                this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
                break block1;
            }
            this.context.close();
        }
    }

    @Override
    public void doAccept() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doConnect() throws IOException {
        try {
            this.channel.finishConnect();
            this.didConnect();
        }
        catch (ConnectException error) {
            this.didClose();
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    @Override
    public void doRead() {
        block21: while (true) {
            SSLEngineResult result;
            try {
                result = this.sslEngine.unwrap(this.readBuffer, this.inputBuffer);
            }
            catch (SSLException error) {
                this.socket.didFail(error);
                this.context.close();
                return;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.socket.didFail(error);
                    this.context.close();
                    return;
                }
                throw error;
            }
            SSLEngineResult.Status sslStatus = result.getStatus();
            switch (sslStatus) {
                case OK: {
                    if (this.inputBuffer.position() > 0) {
                        ((Buffer)this.inputBuffer).flip();
                        this.socket.doRead();
                        if (this.inputBuffer.hasRemaining()) {
                            this.inputBuffer.compact();
                        } else {
                            ((Buffer)this.inputBuffer).clear();
                        }
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    block22: while (true) {
                        switch (handshakeStatus) {
                            case NEED_UNWRAP: {
                                this.context.flowControl(FlowModifier.ENABLE_READ);
                                if (!this.readBuffer.hasRemaining()) break block21;
                                continue block21;
                            }
                            case NEED_WRAP: {
                                this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
                                break block21;
                            }
                            case NEED_TASK: {
                                do {
                                    Runnable task;
                                    if ((task = this.sslEngine.getDelegatedTask()) == null) continue;
                                    task.run();
                                    continue block22;
                                } while ((handshakeStatus = this.sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_TASK);
                                continue block22;
                            }
                            case FINISHED: {
                                this.handshakeAcknowledged();
                                break block21;
                            }
                            case NOT_HANDSHAKING: {
                                break block21;
                            }
                            default: {
                                throw new AssertionError((Object)handshakeStatus);
                            }
                        }
                        break;
                    }
                }
                case CLOSED: {
                    this.receivedClose();
                    break block21;
                }
                case BUFFER_UNDERFLOW: {
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            this.context.flowControl(FlowModifier.ENABLE_READ);
                            break block21;
                        }
                        case NEED_WRAP: {
                            this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
                            break block21;
                        }
                        case NOT_HANDSHAKING: {
                            break block21;
                        }
                    }
                    throw new AssertionError((Object)handshakeStatus);
                }
                case BUFFER_OVERFLOW: {
                    this.context.close();
                    break block21;
                }
                default: {
                    throw new AssertionError((Object)sslStatus);
                }
            }
            break;
        }
    }

    @Override
    public void doWrite() {
        SSLEngineResult result;
        if ((this.status & 0x40) != 0 && !this.outputBuffer.hasRemaining()) {
            ((Buffer)this.outputBuffer).clear();
            this.socket.doWrite();
            ((Buffer)this.outputBuffer).flip();
        }
        try {
            result = this.sslEngine.wrap(this.outputBuffer, this.writeBuffer);
        }
        catch (SSLException error) {
            this.socket.didFail(error);
            this.context.close();
            return;
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.socket.didFail(error);
                this.context.close();
                return;
            }
            throw error;
        }
        SSLEngineResult.Status sslStatus = result.getStatus();
        block1 : switch (sslStatus) {
            case OK: {
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                block16: while (true) {
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            this.context.flowControl(FlowModifier.ENABLE_READ);
                            break block1;
                        }
                        case NEED_WRAP: {
                            this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
                            break block1;
                        }
                        case FINISHED: {
                            this.context.flowControl(FlowModifier.DISABLE_WRITE);
                            this.handshakeFinished();
                            break block1;
                        }
                        case NEED_TASK: {
                            do {
                                Runnable task;
                                if ((task = this.sslEngine.getDelegatedTask()) == null) continue;
                                task.run();
                                continue block16;
                            } while ((handshakeStatus = this.sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_TASK);
                            continue block16;
                        }
                        case NOT_HANDSHAKING: {
                            break block1;
                        }
                    }
                    break;
                }
                throw new AssertionError((Object)handshakeStatus);
            }
            case CLOSED: {
                this.context.close();
                break;
            }
            case BUFFER_UNDERFLOW: {
                this.context.close();
                break;
            }
            case BUFFER_OVERFLOW: {
                this.context.close();
                break;
            }
            default: {
                throw new AssertionError((Object)sslStatus);
            }
        }
    }

    @Override
    public void didWrite() {
        int status = this.status;
        if ((status & 0x10) != 0) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            block6: while (true) {
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        this.context.flowControl(FlowModifier.DISABLE_WRITE_ENABLE_READ);
                        break block6;
                    }
                    case NEED_WRAP: {
                        this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
                        break block6;
                    }
                    case NEED_TASK: {
                        do {
                            Runnable task;
                            if ((task = this.sslEngine.getDelegatedTask()) == null) continue;
                            task.run();
                            continue block6;
                        } while ((handshakeStatus = this.sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_TASK);
                        continue block6;
                    }
                    case NOT_HANDSHAKING: {
                        break block6;
                    }
                    default: {
                        throw new AssertionError((Object)handshakeStatus);
                    }
                }
                break;
            }
        } else if ((status & 0x20) != 0) {
            this.handshakeAcknowledged();
        } else if ((status & 0x40) != 0) {
            this.socket.didWrite();
        }
    }

    void handshakeFinished() {
        int newStatus;
        int oldStatus;
        while (((oldStatus = this.status) & 0x30) != 32 && !STATUS.compareAndSet(this, oldStatus, newStatus = oldStatus & 0xFFFFFFEF | 0x20)) {
        }
    }

    void handshakeAcknowledged() {
        int oldStatus;
        while (((oldStatus = this.status) & 0x30) != 0) {
            int newStatus = oldStatus & 0xFFFFFFCF | 0x40;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.socket.didSecure();
            this.context.flowControl(this.flowControl);
            break;
        }
    }

    void receivedClose() {
        block2: {
            while (true) {
                int newStatus;
                int oldStatus;
                if (((oldStatus = this.status) & 0x100) != 0) {
                    newStatus = oldStatus & 0xFFFFFEFF;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    this.context.close();
                    break block2;
                }
                if ((oldStatus & 0x80) != 0) break block2;
                newStatus = oldStatus & 0xFFFFFFBF | 0x80;
                if (STATUS.compareAndSet(this, oldStatus, newStatus)) break;
            }
            this.sslEngine.closeOutbound();
            this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
        }
    }

    void willConnect() {
        int oldStatus;
        while (((oldStatus = this.status) & 4) == 0) {
            int newStatus = oldStatus | 4;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.socket.willConnect();
            break;
        }
    }

    void didConnect() throws SSLException {
        int oldStatus;
        block4: while (((oldStatus = this.status) & 0x1C) != 24) {
            int newStatus = oldStatus & 0xFFFFFFFB | 0x18;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            if ((oldStatus & 8) != (newStatus & 8)) {
                this.socket.didConnect();
            }
            if ((oldStatus & 0x10) != (newStatus & 0x10)) {
                this.socket.willSecure();
            }
            this.sslEngine.beginHandshake();
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    this.context.flowControl(FlowModifier.ENABLE_READ);
                    break block4;
                }
                case NEED_WRAP: {
                    this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
                    break block4;
                }
                default: {
                    throw new AssertionError((Object)handshakeStatus);
                }
            }
        }
    }

    @Override
    public void didClose() {
        int oldStatus;
        while (((oldStatus = this.status) & 0x1FC) != 0) {
            int newStatus = oldStatus & 0xFFFFFE03;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.socket.didDisconnect();
            break;
        }
    }

    @Override
    public void didTimeout() {
        this.socket.didTimeout();
    }

    @Override
    public void didFail(Throwable error) {
        if (!(error instanceof IOException)) {
            this.socket.didFail(error);
        }
        this.context.close();
    }
}

