/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import swim.concurrent.Cont;
import swim.io.Station;
import swim.io.StationTransport;
import swim.io.TransportSettings;

final class StationThread
extends Thread {
    final Station station;
    final Selector selector;
    final ConcurrentLinkedQueue<StationTransport> reselectQueue;
    long lastIdleCheck;
    static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);

    StationThread(Station station) {
        this.setName("SwimStation" + THREAD_COUNT.getAndIncrement());
        this.station = station;
        try {
            this.selector = Selector.open();
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
        this.reselectQueue = new ConcurrentLinkedQueue();
        this.lastIdleCheck = System.currentTimeMillis();
    }

    @Override
    public void run() {
        Station station = this.station;
        Throwable failure = null;
        try {
            station.startLatch.countDown();
            station.didStart();
            do {
                this.reflow();
                this.select();
                this.checkIdle();
            } while ((Station.STATUS.get(station) & 2) == 0);
            station.willStop();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
            station.didFail(cause);
        }
        try {
            this.closeAll();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            this.selector.close();
        }
        catch (IOException cause) {
            failure = cause;
            station.didFail(cause);
        }
        try {
            Station.STATUS.set(station, 2);
            station.stopLatch.countDown();
            station.didStop();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    void reselect(StationTransport context) {
        this.reselectQueue.add(context);
        this.selector.wakeup();
    }

    void reflow() {
        StationTransport context;
        while ((context = this.reselectQueue.poll()) != null) {
            try {
                this.reflow(context);
            }
            catch (Throwable cause) {
                if (!Cont.isNonFatal((Throwable)cause)) {
                    throw cause;
                }
                this.station.transportDidFail(context.transport, cause);
            }
        }
    }

    void reflow(StationTransport context) {
        SelectionKey selectionKey = context.selectionKey;
        int interestOps = StationTransport.FLOW_CONTROL.get(context).toSelectorOps();
        if (selectionKey != null) {
            try {
                selectionKey.interestOps(interestOps);
            }
            catch (CancelledKeyException cause) {
                context.didClose();
            }
        } else {
            try {
                context.selectionKey = context.transport.channel().register(this.selector, interestOps, context);
            }
            catch (CancelledKeyException | ClosedChannelException cause) {
                context.didClose();
            }
            catch (Throwable cause) {
                if (!Cont.isNonFatal((Throwable)cause)) {
                    throw cause;
                }
                context.didFail(cause);
            }
        }
    }

    void select() {
        int selectedCount;
        try {
            selectedCount = this.selector.select(this.station.transportSettings.idleInterval);
        }
        catch (IOException cause) {
            this.station.didFail(cause);
            return;
        }
        if (selectedCount > 0) {
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey selectionKey = selectedKeys.next();
                selectedKeys.remove();
                Object attachment = selectionKey.attachment();
                if (!(attachment instanceof StationTransport)) continue;
                StationTransport context = (StationTransport)attachment;
                try {
                    this.select(selectionKey, context);
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    this.station.transportDidFail(context.transport, cause);
                }
            }
        }
    }

    void select(SelectionKey selectionKey, StationTransport context) {
        try {
            int readyOps = selectionKey.readyOps();
            if ((readyOps & 0x10) != 0) {
                this.doAccept(selectionKey, context);
            }
            if ((readyOps & 8) != 0) {
                this.doConnect(selectionKey, context);
            }
            if ((readyOps & 1) != 0) {
                this.doRead(selectionKey, context);
            }
            if ((readyOps & 4) != 0) {
                this.doWrite(selectionKey, context);
            }
        }
        catch (CancelledKeyException cause) {
            context.didClose();
        }
    }

    void checkIdle() {
        TransportSettings transportSettings = this.station.transportSettings;
        long now = System.currentTimeMillis();
        if (now - this.lastIdleCheck >= transportSettings.idleInterval) {
            for (SelectionKey key : this.selector.keys()) {
                StationTransport context = (StationTransport)key.attachment();
                if (context == null) continue;
                long idleTimeout = context.idleTimeout();
                if (idleTimeout < 0L) {
                    idleTimeout = transportSettings.idleTimeout;
                }
                if (idleTimeout <= 0L || now - context.lastSelectTime <= idleTimeout) continue;
                Throwable failure = null;
                try {
                    key.channel().close();
                }
                catch (IOException cause) {
                    failure = cause;
                }
                try {
                    context.didTimeout();
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    failure = cause;
                }
                try {
                    context.didClose();
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    failure = cause;
                }
                if (failure == null) continue;
                this.station.transportDidFail(context.transport, failure);
            }
            this.lastIdleCheck = now;
        }
    }

    void doAccept(SelectionKey selectionKey, StationTransport context) {
        context.lastSelectTime = System.currentTimeMillis();
        context.doAccept();
    }

    void doConnect(SelectionKey selectionKey, StationTransport context) {
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
        context.lastSelectTime = System.currentTimeMillis();
        context.doConnect();
    }

    void doRead(SelectionKey selectionKey, StationTransport context) {
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
        context.lastSelectTime = System.currentTimeMillis();
        context.cueRead();
    }

    void doWrite(SelectionKey selectionKey, StationTransport context) {
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        context.lastSelectTime = System.currentTimeMillis();
        context.cueWrite();
    }

    void closeAll() {
        for (SelectionKey selectionKey : this.selector.keys()) {
            StationTransport context = (StationTransport)selectionKey.attachment();
            if (context == null) continue;
            try {
                context.close();
            }
            catch (Throwable cause) {
                if (!Cont.isNonFatal((Throwable)cause)) {
                    throw cause;
                }
                this.station.transportDidFail(context.transport, cause);
            }
        }
    }
}

