/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.codec.Debug;
import swim.codec.Output;
import swim.io.FlowModifier;

public enum FlowControl implements Debug
{
    WAIT(0),
    ACCEPT(1),
    CONNECT(2),
    ACCEPT_CONNECT(3),
    READ(4),
    ACCEPT_READ(5),
    CONNECT_READ(6),
    ACCEPT_CONNECT_READ(7),
    WRITE(8),
    ACCEPT_WRITE(9),
    CONNECT_WRITE(10),
    ACCEPT_CONNECT_WRITE(11),
    READ_WRITE(12),
    ACCEPT_READ_WRITE(13),
    CONNECT_READ_WRITE(14),
    ACCEPT_CONNECT_READ_WRITE(15);

    private final int flags;

    private FlowControl(int flags) {
        this.flags = flags;
    }

    public boolean isAcceptEnabled() {
        return (this.flags & 1) != 0;
    }

    public boolean isConnectEnabled() {
        return (this.flags & 2) != 0;
    }

    public boolean isReadEnabled() {
        return (this.flags & 4) != 0;
    }

    public boolean isWriteEnabled() {
        return (this.flags & 8) != 0;
    }

    public FlowControl acceptDisabled() {
        return FlowControl.fromFlags(this.flags & 0xFFFFFFFE);
    }

    public FlowControl acceptEnabled() {
        return FlowControl.fromFlags(this.flags | 1);
    }

    public FlowControl connectDisabled() {
        return FlowControl.fromFlags(this.flags & 0xFFFFFFFD);
    }

    public FlowControl connectEnabled() {
        return FlowControl.fromFlags(this.flags | 2);
    }

    public FlowControl readDisabled() {
        return FlowControl.fromFlags(this.flags & 0xFFFFFFFB);
    }

    public FlowControl readEnabled() {
        return FlowControl.fromFlags(this.flags | 4);
    }

    public FlowControl writeDisabled() {
        return FlowControl.fromFlags(this.flags & 0xFFFFFFF7);
    }

    public FlowControl writeEnabled() {
        return FlowControl.fromFlags(this.flags | 8);
    }

    public FlowControl modify(FlowModifier flowModifier) {
        int flags = this.flags;
        if (flowModifier.isReadDisabled()) {
            flags &= 0xFFFFFFFB;
        }
        if (flowModifier.isWriteDisabled()) {
            flags &= 0xFFFFFFF7;
        }
        if (flowModifier.isReadEnabled()) {
            flags |= 4;
        }
        if (flowModifier.isWriteEnabled()) {
            flags |= 8;
        }
        return FlowControl.fromFlags(flags);
    }

    public FlowControl or(FlowControl that) {
        return FlowControl.fromFlags(this.flags | that.flags);
    }

    public FlowControl xor(FlowControl that) {
        return FlowControl.fromFlags(this.flags ^ that.flags);
    }

    public FlowControl and(FlowControl that) {
        return FlowControl.fromFlags(this.flags & that.flags);
    }

    public FlowControl not() {
        return FlowControl.fromFlags(~this.flags & 0xF);
    }

    public int toSelectorOps() {
        int flags = this.flags;
        int selectorOps = 0;
        if ((flags & 1) != 0) {
            selectorOps |= 0x10;
        }
        if ((flags & 2) != 0) {
            selectorOps |= 8;
        }
        if ((flags & 4) != 0) {
            selectorOps |= 1;
        }
        if ((flags & 8) != 0) {
            selectorOps |= 4;
        }
        return selectorOps;
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("FlowControl").write(46).write(this.name());
        return output;
    }

    private static FlowControl fromFlags(int flags) {
        switch (flags) {
            case 0: {
                return WAIT;
            }
            case 1: {
                return ACCEPT;
            }
            case 2: {
                return CONNECT;
            }
            case 3: {
                return ACCEPT_CONNECT;
            }
            case 4: {
                return READ;
            }
            case 5: {
                return ACCEPT_READ;
            }
            case 6: {
                return CONNECT_READ;
            }
            case 7: {
                return ACCEPT_CONNECT_READ;
            }
            case 8: {
                return WRITE;
            }
            case 9: {
                return ACCEPT_WRITE;
            }
            case 10: {
                return CONNECT_WRITE;
            }
            case 11: {
                return ACCEPT_CONNECT_WRITE;
            }
            case 12: {
                return READ_WRITE;
            }
            case 13: {
                return ACCEPT_READ_WRITE;
            }
            case 14: {
                return CONNECT_READ_WRITE;
            }
            case 15: {
                return ACCEPT_CONNECT_READ_WRITE;
            }
        }
        throw new IllegalArgumentException("0x" + Integer.toHexString(flags));
    }

    public static FlowControl fromSelectorOps(int selectorOps) {
        int flags = 0;
        if ((selectorOps & 0x10) != 0) {
            flags |= 1;
        }
        if ((selectorOps & 8) != 0) {
            flags |= 2;
        }
        if ((selectorOps & 1) != 0) {
            flags |= 4;
        }
        if ((selectorOps & 4) != 0) {
            flags |= 8;
        }
        return FlowControl.fromFlags(flags);
    }
}

