/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.InputBuffer;
import swim.codec.OutputBuffer;
import swim.concurrent.Cont;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpModem;
import swim.io.IpModemContext;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketContext;

public class IpSocketModem<I, O>
implements IpSocket,
IpModemContext<I, O> {
    final IpModem<I, O> modem;
    final ConcurrentLinkedQueue<Decoder<? extends I>> readerQueue;
    final ConcurrentLinkedQueue<Encoder<?, ? extends O>> writerQueue;
    protected volatile IpSocketContext context;
    volatile Decoder<? extends I> reading;
    volatile Encoder<?, ? extends O> writing;

    public IpSocketModem(IpModem<I, O> modem) {
        this.modem = modem;
        this.readerQueue = new ConcurrentLinkedQueue();
        this.writerQueue = new ConcurrentLinkedQueue();
    }

    @Override
    public IpSocketContext ipSocketContext() {
        return this.context;
    }

    @Override
    public void setIpSocketContext(IpSocketContext context) {
        this.context = context;
        this.modem.setIpModemContext(this);
    }

    @Override
    public boolean isConnected() {
        return this.context.isConnected();
    }

    @Override
    public boolean isClient() {
        return this.context.isClient();
    }

    @Override
    public boolean isServer() {
        return this.context.isServer();
    }

    @Override
    public boolean isSecure() {
        return this.context.isSecure();
    }

    @Override
    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    @Override
    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    @Override
    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    @Override
    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    @Override
    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    @Override
    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    @Override
    public IpSettings ipSettings() {
        return this.context.ipSettings();
    }

    @Override
    public <I2 extends I> void read(Decoder<I2> reader) {
        IpSocketContext context;
        this.readerQueue.add(reader);
        if (this.reading == null && (context = this.context) != null) {
            context.flowControl(FlowModifier.ENABLE_READ);
        }
    }

    @Override
    public <O2 extends O> void write(Encoder<?, O2> writer) {
        IpSocketContext context;
        this.writerQueue.add(writer);
        if (this.writing == null && (context = this.context) != null) {
            context.flowControl(FlowModifier.ENABLE_WRITE);
        }
    }

    @Override
    public long idleTimeout() {
        return this.modem.idleTimeout();
    }

    @Override
    public void doRead() {
        IpSocketContext context = this.context;
        if (context == null) {
            return;
        }
        InputBuffer inputBuffer = context.inputBuffer();
        Decoder<? extends I> reader = this.reading;
        do {
            if (reader != null) {
                int newIndex;
                int oldIndex;
                do {
                    oldIndex = inputBuffer.index();
                    inputBuffer = inputBuffer.isPart(true);
                    reader = reader.feed(inputBuffer);
                } while (oldIndex != (newIndex = inputBuffer.index()) && inputBuffer.isCont() && reader.isCont());
                if (reader.isCont()) {
                    this.reading = reader;
                    break;
                }
                if (reader.isDone()) {
                    this.modem.didRead(reader.bind());
                } else if (reader.isError()) {
                    this.modem.didFail(reader.trap());
                }
            }
            if ((reader = this.readerQueue.poll()) != null) {
                this.reading = reader;
                continue;
            }
            this.modem.doRead();
            reader = this.readerQueue.poll();
            this.reading = reader;
            if (reader != null) continue;
            context = this.context;
            if (context == null) break;
            context.flowControl(FlowModifier.DISABLE_READ);
            this.reconcileReadFlowControl();
            break;
        } while (inputBuffer.isCont());
    }

    void reconcileReadFlowControl() {
        IpSocketContext context;
        while ((context = this.context) != null) {
            Decoder<? extends I> reader = this.reading;
            if (reader != null) {
                context.flowControl(FlowModifier.ENABLE_READ);
            } else {
                this.reading = reader = this.readerQueue.poll();
                if (reader != null) continue;
                context.flowControl(FlowModifier.DISABLE_READ);
            }
            if (reader != this.reading) continue;
            break;
        }
    }

    @Override
    public void doWrite() {
        int newIndex;
        int oldIndex;
        Encoder writer = this.writing;
        if (writer == null) {
            writer = this.writerQueue.poll();
            this.writing = writer;
            if (writer == null) {
                IpSocketContext context = this.context;
                if (context != null) {
                    context.flowControl(FlowModifier.DISABLE_WRITE);
                    this.reconcileWriteFlowControl();
                }
                return;
            }
        }
        OutputBuffer outputBuffer = this.context.outputBuffer();
        do {
            oldIndex = outputBuffer.index();
            outputBuffer = outputBuffer.isPart(true);
            writer = writer.pull(outputBuffer);
        } while (oldIndex != (newIndex = outputBuffer.index()) && outputBuffer.isCont() && writer.isCont());
        this.writing = writer;
        if (newIndex == 0) {
            this.didWrite();
        }
    }

    @Override
    public void didWrite() {
        Encoder<?, ? extends O> writer = this.writing;
        if (writer != null && !writer.isCont()) {
            if (writer.isDone()) {
                this.modem.didWrite(writer.bind());
            } else if (writer.isError()) {
                this.modem.didFail(writer.trap());
            }
            writer = this.writerQueue.poll();
            if (writer != null) {
                this.writing = writer;
            } else {
                IpSocketContext context;
                this.modem.doWrite();
                this.writing = writer = this.writerQueue.poll();
                if (writer == null && (context = this.context) != null) {
                    context.flowControl(FlowModifier.DISABLE_WRITE);
                    this.reconcileWriteFlowControl();
                }
            }
        }
    }

    void reconcileWriteFlowControl() {
        IpSocketContext context;
        while ((context = this.context) != null) {
            Encoder<?, ? extends O> writer = this.writing;
            if (writer != null) {
                context.flowControl(FlowModifier.ENABLE_WRITE);
            } else {
                this.writing = writer = this.writerQueue.poll();
                if (writer != null) continue;
                context.flowControl(FlowModifier.DISABLE_WRITE);
            }
            if (writer != this.writing) continue;
            break;
        }
    }

    @Override
    public void willConnect() {
        this.modem.willConnect();
    }

    @Override
    public void didConnect() {
        if (this.reading != null) {
            if (this.writing != null) {
                this.context.flowControl(FlowModifier.ENABLE_READ_WRITE);
            } else {
                this.context.flowControl(FlowModifier.DISABLE_WRITE_ENABLE_READ);
            }
        } else if (this.writing != null) {
            this.context.flowControl(FlowModifier.DISABLE_READ_ENABLE_WRITE);
        }
        this.modem.didConnect();
    }

    @Override
    public void willSecure() {
        this.modem.willSecure();
    }

    @Override
    public void didSecure() {
        this.modem.didSecure();
    }

    @Override
    public void willBecome(IpSocket socket) {
        this.modem.willBecome(socket);
    }

    @Override
    public void didBecome(IpSocket socket) {
        this.modem.didBecome(socket);
    }

    @Override
    public void didTimeout() {
        this.modem.didTimeout();
    }

    @Override
    public void didDisconnect() {
        this.context.flowControl(FlowModifier.DISABLE_READ_WRITE);
        Decoder<? extends I> reader = this.reading;
        this.reading = null;
        Throwable failure = null;
        do {
            if (reader == null) continue;
            try {
                reader.feed(InputBuffer.done());
            }
            catch (Throwable cause) {
                if (!Cont.isNonFatal((Throwable)cause)) {
                    throw cause;
                }
                failure = cause;
            }
        } while ((reader = this.readerQueue.poll()) != null);
        Encoder<?, ? extends O> writer = this.writing;
        this.writing = null;
        do {
            if (writer == null) continue;
            try {
                writer.pull(OutputBuffer.done());
            }
            catch (Throwable cause) {
                if (!Cont.isNonFatal((Throwable)cause)) {
                    throw cause;
                }
                failure = cause;
            }
        } while ((writer = this.writerQueue.poll()) != null);
        try {
            this.modem.didDisconnect();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.close();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    @Override
    public void didFail(Throwable error) {
        this.modem.didFail(error);
    }

    @Override
    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    @Override
    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    @Override
    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public void become(IpSocket socket) {
        IpSocketContext context = this.context;
        this.context = null;
        context.become(socket);
    }

    @Override
    public void close() {
        this.context.close();
    }
}

