/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.Cont;
import swim.concurrent.TaskFunction;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.Station;
import swim.io.StationReader;
import swim.io.StationWriter;
import swim.io.Transport;
import swim.io.TransportContext;
import swim.io.TransportRef;
import swim.io.TransportSettings;

final class StationTransport
implements TransportContext,
TransportRef {
    final Station station;
    final Transport transport;
    volatile FlowControl flowControl;
    StationReader reader;
    StationWriter writer;
    SelectionKey selectionKey;
    volatile long lastSelectTime;
    static final AtomicReferenceFieldUpdater<StationTransport, FlowControl> FLOW_CONTROL = AtomicReferenceFieldUpdater.newUpdater(StationTransport.class, FlowControl.class, "flowControl");

    StationTransport(Station station, Transport transport, FlowControl flowControl) {
        this.station = station;
        this.transport = transport;
        this.flowControl = flowControl;
    }

    void reselect() {
        this.station.reselect(this);
    }

    long idleTimeout() {
        return this.transport.idleTimeout();
    }

    @Override
    public TransportSettings transportSettings() {
        return this.station.transportSettings;
    }

    @Override
    public FlowControl flowControl() {
        return FLOW_CONTROL.get(this);
    }

    @Override
    public void flowControl(FlowControl newFlowControl) {
        FlowControl oldFlowControl = FLOW_CONTROL.getAndSet(this, newFlowControl);
        if (!oldFlowControl.equals((Object)newFlowControl)) {
            this.reselect();
        }
    }

    @Override
    public FlowControl flowControl(FlowModifier flowModifier) {
        FlowControl newFlowControl;
        FlowControl oldFlowControl;
        while (!(oldFlowControl = FLOW_CONTROL.get(this)).equals((Object)(newFlowControl = oldFlowControl.modify(flowModifier)))) {
            if (!FLOW_CONTROL.compareAndSet(this, oldFlowControl, newFlowControl)) continue;
            this.reselect();
            return newFlowControl;
        }
        return newFlowControl;
    }

    @Override
    public void close() {
        Throwable failure = null;
        try {
            this.transport.channel().close();
        }
        catch (IOException cause) {
            this.station.transportDidFail(this.transport, cause);
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.didClose();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    void doAccept() {
        try {
            this.transport.doAccept();
            this.station.transportDidAccept(this.transport);
        }
        catch (ClosedChannelException cause) {
            this.didClose();
        }
        catch (IOException cause) {
            this.didFail(cause);
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            this.didFail(cause);
        }
    }

    void doConnect() {
        FlowControl newFlowControl;
        FlowControl oldFlowControl;
        while ((oldFlowControl = FLOW_CONTROL.get(this)).isConnectEnabled() && !FLOW_CONTROL.compareAndSet(this, oldFlowControl, newFlowControl = oldFlowControl.connectDisabled())) {
        }
        try {
            this.transport.doConnect();
            this.station.transportDidConnect(this.transport);
        }
        catch (ClosedChannelException cause) {
            this.didClose();
        }
        catch (IOException cause) {
            this.didFail(cause);
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            this.didFail(cause);
        }
    }

    void cueRead() {
        StationReader reader = this.reader;
        try {
            if (reader == null) {
                reader = new StationReader(this);
                this.station.stage.task((TaskFunction)reader);
                this.reader = reader;
            }
            reader.cue();
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                this.close();
            }
            throw cause;
        }
    }

    boolean doRead() {
        ByteBuffer readBuffer = this.transport.readBuffer();
        ReadableByteChannel channel = (ReadableByteChannel)((Object)this.transport.channel());
        boolean yield = false;
        while (FLOW_CONTROL.get(this).isReadEnabled()) {
            int count;
            try {
                count = channel.read(readBuffer);
            }
            catch (ClosedChannelException cause) {
                this.didClose();
                break;
            }
            catch (IOException cause) {
                this.didFail(cause);
                break;
            }
            catch (Throwable cause) {
                if (!Cont.isNonFatal((Throwable)cause)) {
                    throw cause;
                }
                this.didFail(cause);
                break;
            }
            if (count < 0) {
                this.close();
                break;
            }
            if (readBuffer.position() > 0) {
                ((Buffer)readBuffer).flip();
                try {
                    this.transport.doRead();
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    this.didFail(cause);
                    break;
                }
                if (readBuffer.hasRemaining()) {
                    int currentPos = readBuffer.position();
                    readBuffer.compact();
                    if (count != 0 || currentPos != 0) continue;
                    yield = true;
                    break;
                }
                ((Buffer)readBuffer).clear();
                continue;
            }
            this.reselect();
            break;
        }
        return yield;
    }

    void cueWrite() {
        StationWriter writer = this.writer;
        try {
            if (writer == null) {
                writer = new StationWriter(this);
                this.station.stage.task((TaskFunction)writer);
                this.writer = writer;
            }
            writer.cue();
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                this.close();
            }
            throw cause;
        }
    }

    void doWrite() {
        block14: {
            block15: {
                ByteBuffer writeBuffer = this.transport.writeBuffer();
                WritableByteChannel channel = (WritableByteChannel)((Object)this.transport.channel());
                while (true) {
                    if (writeBuffer.hasRemaining()) {
                        int count;
                        try {
                            count = channel.write(writeBuffer);
                        }
                        catch (ClosedChannelException cause) {
                            this.didClose();
                            break block14;
                        }
                        catch (IOException cause) {
                            this.didFail(cause);
                            break block14;
                        }
                        catch (Throwable cause) {
                            if (!Cont.isNonFatal((Throwable)cause)) {
                                throw cause;
                            }
                            this.didFail(cause);
                            break block14;
                        }
                        if (count > 0) {
                            if (!writeBuffer.hasRemaining()) continue;
                            this.reselect();
                        } else {
                            this.reselect();
                        }
                        break block14;
                    }
                    if (!FLOW_CONTROL.get(this).isWriteEnabled()) break block15;
                    ((Buffer)writeBuffer).clear();
                    try {
                        while (writeBuffer.hasRemaining() && FLOW_CONTROL.get(this).isWriteEnabled()) {
                            int oldPosition = writeBuffer.position();
                            this.transport.doWrite();
                            int newPosition = writeBuffer.position();
                            if (oldPosition != newPosition) {
                                this.transport.didWrite();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable cause) {
                        if (!Cont.isNonFatal((Throwable)cause)) {
                            throw cause;
                        }
                        this.didFail(cause);
                        break block14;
                    }
                    ((Buffer)writeBuffer).flip();
                    if (!writeBuffer.hasRemaining()) break;
                }
                this.reselect();
                break block14;
            }
            this.reselect();
        }
    }

    void didTimeout() {
        Throwable failure = null;
        try {
            this.transport.didTimeout();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.station.transportDidTimeout(this.transport);
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    void didClose() {
        Throwable failure = null;
        try {
            StationReader reader = this.reader;
            if (reader != null) {
                reader.cancel();
            }
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            StationWriter writer = this.writer;
            if (writer != null) {
                writer.cancel();
            }
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            this.transport.didClose();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            this.station.transportDidClose(this.transport);
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    void didFail(Throwable error) {
        Throwable failure = null;
        try {
            this.transport.didFail(error);
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.station.transportDidFail(this.transport, error);
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }
}

