/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.json.Json;
import swim.json.JsonParser;
import swim.util.Builder;

final class ArrayParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final Builder<I, V> builder;
    final Parser<V> valueParser;
    final int step;

    ArrayParser(JsonParser<I, V> json, Builder<I, V> builder, Parser<V> valueParser, int step) {
        this.json = json;
        this.builder = builder;
        this.valueParser = valueParser;
        this.step = step;
    }

    ArrayParser(JsonParser<I, V> json) {
        this(json, null, null, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, Builder<I, V> builder, Parser<V> valueParser, int step) {
        int c = 0;
        if (step == 1) {
            while (input.isCont() && Json.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 91) return ArrayParser.error((Diagnostic)Diagnostic.expected((int)91, (Input)input));
                input = input.step();
                step = 2;
            } else if (input.isDone()) {
                return ArrayParser.error((Diagnostic)Diagnostic.expected((int)91, (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Json.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (builder == null) {
                    builder = json.arrayBuilder();
                }
                if (c == 93) {
                    input = input.step();
                    return ArrayParser.done((Object)builder.bind());
                }
                step = 3;
            } else if (input.isDone()) {
                return ArrayParser.error((Diagnostic)Diagnostic.expected((int)93, (Input)input));
            }
        }
        while (step >= 3 && !input.isEmpty()) {
            if (step == 3) {
                if (valueParser == null) {
                    valueParser = json.parseValue(input);
                }
                while (valueParser.isCont() && !input.isEmpty()) {
                    valueParser = valueParser.feed(input);
                }
                if (valueParser.isDone()) {
                    builder.add(json.item(valueParser.bind()));
                    valueParser = null;
                    step = 4;
                } else {
                    if (!valueParser.isError()) break;
                    return valueParser;
                }
            }
            if (step != 4) continue;
            while (input.isCont() && Json.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 44) {
                    input = input.step();
                    step = 3;
                    continue;
                }
                if (c != 93) return ArrayParser.error((Diagnostic)Diagnostic.expected((String)"',' or ']'", (Input)input));
                input = input.step();
                return ArrayParser.done((Object)builder.bind());
            }
            if (!input.isDone()) break;
            return ArrayParser.error((Diagnostic)Diagnostic.expected((int)93, (Input)input));
        }
        if (!input.isError()) return new ArrayParser<I, Object>(json, builder, (Parser<Object>)valueParser, step);
        return ArrayParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json) {
        return ArrayParser.parse(input, json, null, null, 1);
    }

    public Parser<V> feed(Input input) {
        return ArrayParser.parse(input, this.json, this.builder, this.valueParser, this.step);
    }
}

