/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.json.Json;
import swim.json.JsonParser;

final class StringParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final Output<V> output;
    final int quote;
    final int code;
    final int step;

    StringParser(JsonParser<I, V> json, Output<V> output, int quote, int code, int step) {
        this.json = json;
        this.output = output;
        this.quote = quote;
        this.code = code;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, Output<V> output, int quote, int code, int step) {
        block26: {
            int c = 0;
            if (step == 1) {
                while (input.isCont() && Json.isWhitespace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (c != 34 && c != 39 || quote != c && quote != 0) return StringParser.error((Diagnostic)Diagnostic.expected((String)"string", (Input)input));
                    input = input.step();
                    if (output == null) {
                        output = json.textOutput();
                    }
                    quote = c;
                    step = 2;
                } else if (input.isDone()) {
                    return StringParser.error((Diagnostic)Diagnostic.expected((String)"string", (Input)input));
                }
            }
            block1: while (true) {
                if (step == 2) {
                    while (input.isCont() && (c = input.head()) >= 32 && c != quote && c != 92) {
                        input = input.step();
                        output = output.write(c);
                    }
                    if (input.isCont()) {
                        if (c == quote) {
                            input = input.step();
                            return StringParser.done((Object)output.bind());
                        }
                        if (c != 92) return StringParser.error((Diagnostic)Diagnostic.expected((int)quote, (Input)input));
                        input = input.step();
                        step = 3;
                    } else if (input.isDone()) {
                        return StringParser.error((Diagnostic)Diagnostic.expected((int)quote, (Input)input));
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c == 34 || c == 36 || c == 39 || c == 47 || c == 64 || c == 91 || c == 92 || c == 93 || c == 123 || c == 125) {
                            input = input.step();
                            output = output.write(c);
                            step = 2;
                            continue;
                        }
                        if (c == 98) {
                            input = input.step();
                            output = output.write(8);
                            step = 2;
                            continue;
                        }
                        if (c == 102) {
                            input = input.step();
                            output = output.write(12);
                            step = 2;
                            continue;
                        }
                        if (c == 110) {
                            input = input.step();
                            output = output.write(10);
                            step = 2;
                            continue;
                        }
                        if (c == 114) {
                            input = input.step();
                            output = output.write(13);
                            step = 2;
                            continue;
                        }
                        if (c == 116) {
                            input = input.step();
                            output = output.write(9);
                            step = 2;
                            continue;
                        }
                        if (c != 117) return StringParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                        input = input.step();
                        step = 4;
                    } else if (input.isDone()) {
                        return StringParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                    }
                }
                if (step < 4) break block26;
                while (input.isCont()) {
                    c = input.head();
                    if (!Base16.isDigit((int)c)) return StringParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    input = input.step();
                    code = 16 * code + Base16.decodeDigit((int)c);
                    if (step <= 6) {
                        ++step;
                        continue;
                    }
                    output = output.write(code);
                    code = 0;
                    step = 2;
                    continue block1;
                }
                break;
            }
            if (input.isDone()) {
                return StringParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
            }
        }
        if (!input.isError()) return new StringParser<I, V>(json, output, quote, code, step);
        return StringParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json) {
        return StringParser.parse(input, json, null, 0, 0, 1);
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, Output<V> output) {
        return StringParser.parse(input, json, output, 0, 0, 1);
    }

    public Parser<V> feed(Input input) {
        return StringParser.parse(input, this.json, this.output, this.quote, this.code, this.step);
    }
}

