/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.json.JsonParser;

final class DecimalParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final StringBuilder builder;
    final int mode;
    final int step;

    DecimalParser(JsonParser<I, V> json, StringBuilder builder, int mode, int step) {
        this.json = json;
        this.builder = builder;
        this.mode = mode;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, StringBuilder builder, int mode, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c == 46) {
                    input = input.step();
                    builder.appendCodePoint(c);
                    step = 2;
                } else {
                    if (mode <= 1 || c != 69 && c != 101) return DecimalParser.error((Diagnostic)Diagnostic.expected((String)"decimal or exponent", (Input)input));
                    input = input.step();
                    builder.appendCodePoint(c);
                    step = 5;
                }
            } else if (input.isDone()) {
                return DecimalParser.error((Diagnostic)Diagnostic.expected((String)"decimal or exponent", (Input)input));
            }
        }
        if (step == 2) {
            if (input.isCont()) {
                c = input.head();
                if (c < 48 || c > 57) return DecimalParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                builder.appendCodePoint(c);
                step = 3;
            } else if (input.isDone()) {
                return DecimalParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 3) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                input = input.step();
                builder.appendCodePoint(c);
            }
            if (input.isCont()) {
                if (mode <= 1) return DecimalParser.done(json.num(builder.toString()));
                step = 4;
            } else if (input.isDone()) {
                return DecimalParser.done(json.num(builder.toString()));
            }
        }
        if (step == 4) {
            c = input.head();
            if (c != 69 && c != 101) return DecimalParser.done(json.num(builder.toString()));
            input = input.step();
            builder.appendCodePoint(c);
            step = 5;
        }
        if (step == 5) {
            if (input.isCont()) {
                c = input.head();
                if (c == 43 || c == 45) {
                    input = input.step();
                    builder.appendCodePoint(c);
                }
                step = 6;
            } else if (input.isDone()) {
                return DecimalParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 6) {
            if (input.isCont()) {
                c = input.head();
                if (c < 48 || c > 57) return DecimalParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                builder.appendCodePoint(c);
                step = 7;
            } else if (input.isDone()) {
                return DecimalParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 7) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                input = input.step();
                builder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                return DecimalParser.done(json.num(builder.toString()));
            }
        }
        if (!input.isError()) return new DecimalParser<I, V>(json, builder, mode, step);
        return DecimalParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, int sign, long value, int mode) {
        StringBuilder builder = new StringBuilder();
        if (sign < 0 && value == 0L) {
            builder.append('-').append('0');
        } else {
            builder.append(value);
        }
        return DecimalParser.parse(input, json, builder, mode, 1);
    }

    public Parser<V> feed(Input input) {
        return DecimalParser.parse(input, this.json, this.builder, this.mode, this.step);
    }
}

