/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.math.BigInteger;
import swim.codec.Output;
import swim.json.JsonParser;
import swim.structure.Attr;
import swim.structure.Bool;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;

public class JsonStructureParser
extends JsonParser<Item, Value> {
    @Override
    public Item item(Value value) {
        return value;
    }

    @Override
    public Value value(Item item) {
        return item.toValue();
    }

    @Override
    public Item field(Value key, Value value) {
        String name;
        if (key instanceof Text && (name = key.stringValue()).length() > 1 && name.charAt(0) == '@') {
            return Attr.of((Text)Text.from((String)name.substring(1)), (Value)value);
        }
        return Slot.of((Value)key, (Value)value);
    }

    @Override
    public Builder<Item, Value> documentBuilder() {
        return Record.create();
    }

    @Override
    public Builder<Item, Value> objectBuilder() {
        return Record.create();
    }

    @Override
    public Builder<Item, Value> arrayBuilder() {
        return Record.create();
    }

    @Override
    public Output<Value> textOutput() {
        return Text.output();
    }

    @Override
    public Value ident(Value value) {
        if (value instanceof Text) {
            String string = value.stringValue();
            if ("true".equals(string)) {
                return Bool.from((boolean)true);
            }
            if ("false".equals(string)) {
                return Bool.from((boolean)false);
            }
            if ("null".equals(string)) {
                return Value.extant();
            }
        }
        return value;
    }

    @Override
    public Value num(int value) {
        return Num.from((int)value);
    }

    @Override
    public Value num(long value) {
        if ((long)((int)value) == value) {
            return Num.from((int)((int)value));
        }
        return Num.from((long)value);
    }

    @Override
    public Value num(float value) {
        return Num.from((float)value);
    }

    @Override
    public Value num(double value) {
        if ((double)((float)value) == value) {
            return Num.from((float)((float)value));
        }
        return Num.from((double)value);
    }

    @Override
    public Value num(BigInteger value) {
        return Num.from((BigInteger)value);
    }

    @Override
    public Value num(String value) {
        return Num.from((String)value);
    }

    @Override
    public Value uint32(int value) {
        return Num.uint32((int)value);
    }

    @Override
    public Value uint64(long value) {
        return Num.uint64((long)value);
    }

    @Override
    public Value bool(boolean value) {
        return Bool.from((boolean)value);
    }
}

