/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.math.BigInteger;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.json.BigIntegerParser;
import swim.json.DecimalParser;
import swim.json.HexadecimalParser;
import swim.json.Json;
import swim.json.JsonParser;

final class NumberParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final int sign;
    final long value;
    final int mode;
    final int step;

    NumberParser(JsonParser<I, V> json, int sign, long value, int mode, int step) {
        this.json = json;
        this.sign = sign;
        this.value = value;
        this.mode = mode;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, int sign, long value, int mode, int step) {
        int c = 0;
        if (step == 1) {
            while (input.isCont() && Json.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 45) {
                    input = input.step();
                    sign = -1;
                }
                step = 2;
            } else if (input.isDone()) {
                return NumberParser.error((Diagnostic)Diagnostic.expected((String)"number", (Input)input));
            }
        }
        if (step == 2) {
            if (input.isCont()) {
                c = input.head();
                if (c == 48) {
                    input = input.step();
                    step = 4;
                } else {
                    if (c < 49 || c > 57) return NumberParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                    input = input.step();
                    value = sign * (c - 48);
                    step = 3;
                }
            } else if (input.isDone()) {
                return NumberParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 3) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                long newValue = 10L * value + (long)(sign * (c - 48));
                if (newValue / value < 10L) return BigIntegerParser.parse(input, json, sign, BigInteger.valueOf(value));
                value = newValue;
                input = input.step();
            }
            if (input.isCont()) {
                step = 4;
            } else if (input.isDone()) {
                return NumberParser.done(json.num(value));
            }
        }
        if (step == 4) {
            if (input.isCont()) {
                c = input.head();
                if (mode > 0 && c == 46 || mode > 1 && (c == 69 || c == 101)) {
                    return DecimalParser.parse(input, json, sign, value, mode);
                }
                if (c != 120 || sign <= 0 || value != 0L) return NumberParser.done(json.num(value));
                input = input.step();
                return HexadecimalParser.parse(input, json);
            }
            if (input.isDone()) {
                return NumberParser.done(json.num(value));
            }
        }
        if (!input.isError()) return new NumberParser<I, V>(json, sign, value, mode, step);
        return NumberParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json) {
        return NumberParser.parse(input, json, 1, 0L, 2, 1);
    }

    static <I, V> Parser<V> parseDecimal(Input input, JsonParser<I, V> json) {
        return NumberParser.parse(input, json, 1, 0L, 1, 1);
    }

    static <I, V> Parser<V> parseInteger(Input input, JsonParser<I, V> json) {
        return NumberParser.parse(input, json, 1, 0L, 0, 1);
    }

    public Parser<V> feed(Input input) {
        return NumberParser.parse(input, this.json, this.sign, this.value, this.mode, this.step);
    }
}

