/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.json.Json;
import swim.json.JsonParser;
import swim.util.Builder;

final class DocumentParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final Builder<I, V> builder;
    final Parser<V> keyParser;
    final Parser<V> valueParser;
    final int step;

    DocumentParser(JsonParser<I, V> json, Builder<I, V> builder, Parser<V> keyParser, Parser<V> valueParser, int step) {
        this.json = json;
        this.builder = builder;
        this.keyParser = keyParser;
        this.valueParser = valueParser;
        this.step = step;
    }

    DocumentParser(JsonParser<I, V> json) {
        this(json, null, null, null, 1);
    }

    public Parser<V> feed(Input input) {
        return DocumentParser.parse(input, this.json, this.builder, this.keyParser, this.valueParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, Builder<I, V> builder, Parser<V> keyParser, Parser<V> valueParser, int step) {
        int c = 0;
        if (step == 1) {
            while (input.isCont() && Json.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 123) return Parser.error((Diagnostic)Diagnostic.expected((int)123, (Input)input));
                input = input.step();
                step = 2;
            } else {
                if (input.isError()) {
                    return Parser.error((Throwable)input.trap());
                }
                if (input.isDone()) {
                    if (builder != null) return Parser.done((Object)builder.bind());
                    builder = json.documentBuilder();
                    return Parser.done((Object)builder.bind());
                }
            }
        }
        if (step == 2) {
            while (input.isCont() && Json.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (builder == null) {
                    builder = json.documentBuilder();
                }
                if (c == 125) {
                    input = input.step();
                    return Parser.done((Object)builder.bind());
                }
                step = 3;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)125, (Input)input));
            }
        }
        while (step >= 3 && !input.isEmpty()) {
            if (step == 3) {
                if (keyParser == null) {
                    keyParser = json.parseString(input);
                }
                while (keyParser.isCont() && !input.isEmpty()) {
                    keyParser = keyParser.feed(input);
                }
                if (keyParser.isDone()) {
                    step = 4;
                } else {
                    if (!keyParser.isError()) break;
                    return keyParser;
                }
            }
            if (step == 4) {
                while (input.isCont() && Json.isWhitespace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (c != 58) return Parser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
                    input = input.step();
                    step = 5;
                } else {
                    if (!input.isDone()) break;
                    return Parser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
                }
            }
            if (step == 5) {
                while (input.isCont() && Json.isWhitespace(input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    step = 6;
                } else {
                    if (!input.isDone()) break;
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"value", (Input)input));
                }
            }
            if (step == 6) {
                if (valueParser == null) {
                    valueParser = json.parseValue(input);
                }
                while (valueParser.isCont() && !input.isEmpty()) {
                    valueParser = valueParser.feed(input);
                }
                if (valueParser.isDone()) {
                    builder.add(json.field(keyParser.bind(), valueParser.bind()));
                    keyParser = null;
                    valueParser = null;
                    step = 7;
                } else {
                    if (!valueParser.isError()) break;
                    return valueParser;
                }
            }
            if (step == 7) {
                while (input.isCont() && Json.isWhitespace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (c == 44) {
                        input = input.step();
                        step = 3;
                    } else {
                        if (c != 125) return Parser.error((Diagnostic)Diagnostic.expected((String)"',' or '}'", (Input)input));
                        input = input.step();
                        step = 8;
                    }
                } else {
                    if (!input.isDone()) break;
                    return Parser.error((Diagnostic)Diagnostic.expected((int)125, (Input)input));
                }
            }
            if (step != 8) continue;
            while (input.isCont()) {
                c = input.head();
                if (!Json.isWhitespace(c)) return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input, (String)"trailing characters after closing '}'"));
                input = input.step();
            }
            return Parser.done((Object)builder.bind());
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        if (!input.isError()) return new DocumentParser<I, Object>(json, builder, (Parser<Object>)keyParser, (Parser<Object>)valueParser, step);
        return Parser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json) {
        return DocumentParser.parse(input, json, null, null, null, 1);
    }
}

