/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.json.JsonWriter;

final class FieldWriter<I, V>
extends Writer<Object, Object> {
    final JsonWriter<I, V> json;
    final V key;
    final V value;
    final Writer<?, ?> part;
    final int step;

    FieldWriter(JsonWriter<I, V> json, V key, V value, Writer<?, ?> part, int step) {
        this.json = json;
        this.key = key;
        this.value = value;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return FieldWriter.write(output, this.json, this.key, this.value, this.part, this.step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, JsonWriter<I, V> json, V key, V value, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? json.writeValue(output, key) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(58);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? json.writeValue(output, value) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new FieldWriter<I, V>(json, key, value, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, JsonWriter<I, V> json, V key, V value) {
        return FieldWriter.write(output, json, key, value, null, 1);
    }
}

