/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.codec.WriterException;

final class StringWriter
extends Writer<Object, Object> {
    final String string;
    final int index;
    final int escape;
    final int step;

    StringWriter(String string, int index, int escape, int step) {
        this.string = string;
        this.index = index;
        this.escape = escape;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return StringWriter.write(output, this.string, this.index, this.escape, this.step);
    }

    static int sizeOf(String string) {
        int size = 0;
        ++size;
        int i = 0;
        int n = string.length();
        while (i < n) {
            int c = string.codePointAt(i);
            size = c == 34 || c == 92 || c == 8 || c == 12 || c == 10 || c == 13 || c == 9 ? (size += 2) : (c < 32 ? (size += 6) : (size += Utf8.sizeOf((int)c)));
            i = string.offsetByCodePoints(i, 1);
        }
        return ++size;
    }

    static Writer<Object, Object> write(Output<?> output, String string, int index, int escape, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(34);
            step = 2;
        }
        int length = string.length();
        while (step >= 2 && step <= 8 && output.isCont()) {
            if (step == 2) {
                if (index < length) {
                    int c = string.codePointAt(index);
                    index = string.offsetByCodePoints(index, 1);
                    if (c == 34 || c == 92) {
                        output = output.write(92);
                        escape = c;
                        step = 3;
                        continue;
                    }
                    if (c == 8) {
                        output = output.write(92);
                        escape = 98;
                        step = 3;
                        continue;
                    }
                    if (c == 12) {
                        output = output.write(92);
                        escape = 102;
                        step = 3;
                        continue;
                    }
                    if (c == 10) {
                        output = output.write(92);
                        escape = 110;
                        step = 3;
                        continue;
                    }
                    if (c == 13) {
                        output = output.write(92);
                        escape = 114;
                        step = 3;
                        continue;
                    }
                    if (c == 9) {
                        output = output.write(92);
                        escape = 116;
                        step = 3;
                        continue;
                    }
                    if (c < 32) {
                        output = output.write(92);
                        escape = c;
                        step = 4;
                        continue;
                    }
                    output = output.write(c);
                    continue;
                }
                step = 9;
                break;
            }
            if (step == 3) {
                output = output.write(escape);
                escape = 0;
                step = 2;
                continue;
            }
            if (step == 4) {
                output = output.write(117);
                step = 5;
                continue;
            }
            if (step == 5) {
                output = output.write((int)Base16.uppercase().encodeDigit(escape >>> 12 & 0xF));
                step = 6;
                continue;
            }
            if (step == 6) {
                output = output.write((int)Base16.uppercase().encodeDigit(escape >>> 8 & 0xF));
                step = 7;
                continue;
            }
            if (step == 7) {
                output = output.write((int)Base16.uppercase().encodeDigit(escape >>> 4 & 0xF));
                step = 8;
                continue;
            }
            if (step != 8) continue;
            output = output.write((int)Base16.uppercase().encodeDigit(escape & 0xF));
            escape = 0;
            step = 2;
        }
        if (step == 9 && output.isCont()) {
            output = output.write(34);
            return Writer.done();
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new StringWriter(string, index, escape, step);
    }

    static Writer<Object, Object> write(Output<?> output, String string) {
        return StringWriter.write(output, string, 0, 0, 1);
    }
}

