/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.json.Json;
import swim.json.JsonParser;

final class ValueParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;

    ValueParser(JsonParser<I, V> json) {
        this.json = json;
    }

    public Parser<V> feed(Input input) {
        return ValueParser.parse(input, this.json);
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json) {
        int c = 0;
        while (input.isCont() && Json.isWhitespace(c = input.head())) {
            input = input.step();
        }
        if (input.isCont()) {
            if (c == 123) {
                return json.parseObject(input);
            }
            if (c == 91) {
                return json.parseArray(input);
            }
            if (Json.isIdentStartChar(c)) {
                return json.parseIdent(input);
            }
            if (c == 34 || c == 39) {
                return json.parseString(input);
            }
            if (c == 45 || c >= 48 && c <= 57) {
                return json.parseNumber(input);
            }
            return Parser.error((Diagnostic)Diagnostic.expected((String)"value", (Input)input));
        }
        if (input.isDone()) {
            return Parser.error((Diagnostic)Diagnostic.expected((String)"value", (Input)input));
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new ValueParser<I, V>(json);
    }
}

