/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.math.BigInteger;
import swim.codec.Input;
import swim.codec.Parser;
import swim.json.JsonParser;

final class BigIntegerParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final int sign;
    final BigInteger value;

    BigIntegerParser(JsonParser<I, V> json, int sign, BigInteger value) {
        this.json = json;
        this.sign = sign;
        this.value = value;
    }

    public Parser<V> feed(Input input) {
        return BigIntegerParser.parse(input, this.json, this.sign, this.value);
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, int sign, BigInteger value) {
        int c;
        while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
            input = input.step();
            value = BigInteger.TEN.multiply(value).add(BigInteger.valueOf(sign * (c - 48)));
        }
        if (!input.isEmpty()) {
            return Parser.done(json.num(value));
        }
        return new BigIntegerParser<I, V>(json, sign, value);
    }
}

